/*
 * Decompiled with CFR 0.152.
 */
package com.github.paweladamski.httpclientmock;

import com.github.paweladamski.httpclientmock.RuleBuilder;
import com.github.paweladamski.httpclientmock.action.Action;
import com.github.paweladamski.httpclientmock.action.ExceptionAction;
import com.github.paweladamski.httpclientmock.action.HeaderAction;
import com.github.paweladamski.httpclientmock.action.StatusResponse;
import com.github.paweladamski.httpclientmock.action.StringResponse;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.http.entity.ContentType;

public class HttpClientResponseBuilder {
    private final RuleBuilder newRule;

    HttpClientResponseBuilder(RuleBuilder rule) {
        this.newRule = rule;
    }

    public HttpClientResponseBuilder withHeader(String name, String value) {
        Action lastAction = this.newRule.getLastAction();
        HeaderAction headerAction = new HeaderAction(lastAction, name, value);
        this.newRule.overrideLastAction(headerAction);
        return this;
    }

    public HttpClientResponseBuilder withStatus(int statusCode) {
        Action lastAction = this.newRule.getLastAction();
        StatusResponse statusAction = new StatusResponse(lastAction, statusCode);
        this.newRule.overrideLastAction(statusAction);
        return this;
    }

    public HttpClientResponseBuilder doAction(Action action) {
        this.newRule.addAction(action);
        return new HttpClientResponseBuilder(this.newRule);
    }

    public HttpClientResponseBuilder doReturn(String response) {
        return this.doReturn(response, Charset.forName("UTF-8"));
    }

    public HttpClientResponseBuilder doReturn(int statusCode, String response) {
        return this.doReturn(statusCode, response, Charset.forName("UTF-8"));
    }

    public HttpClientResponseBuilder doReturn(String response, Charset charset) {
        this.newRule.addAction(new StringResponse(response, charset));
        return new HttpClientResponseBuilder(this.newRule);
    }

    public HttpClientResponseBuilder doReturn(int statusCode, String response, Charset charset) {
        this.newRule.addAction(new StringResponse(statusCode, response, charset));
        return new HttpClientResponseBuilder(this.newRule);
    }

    public HttpClientResponseBuilder doReturnStatus(int statusCode) {
        this.newRule.addAction(new StatusResponse(statusCode));
        return new HttpClientResponseBuilder(this.newRule);
    }

    public HttpClientResponseBuilder doThrowException(IOException exception) {
        this.newRule.addAction(new ExceptionAction(exception));
        return new HttpClientResponseBuilder(this.newRule);
    }

    public HttpClientResponseBuilder doReturnJSON(String response) {
        return this.doReturnJSON(response, Charset.forName("UTF-8"));
    }

    public HttpClientResponseBuilder doReturnJSON(String response, Charset charset) {
        return this.doReturn(response, charset).withHeader("Content-type", ContentType.APPLICATION_JSON.toString());
    }

    public HttpClientResponseBuilder doReturnXML(String response) {
        return this.doReturnXML(response, Charset.forName("UTF-8"));
    }

    public HttpClientResponseBuilder doReturnXML(String response, Charset charset) {
        return this.doReturn(response, charset).withHeader("Content-type", ContentType.APPLICATION_XML.toString());
    }
}

