/*
 * Decompiled with CFR 0.152.
 */
package com.github.paweladamski.httpclientmock;

import com.github.paweladamski.httpclientmock.Rule;
import com.github.paweladamski.httpclientmock.UrlConditions;
import com.github.paweladamski.httpclientmock.UrlParser;
import com.github.paweladamski.httpclientmock.action.Action;
import com.github.paweladamski.httpclientmock.condition.Condition;
import com.github.paweladamski.httpclientmock.condition.HttpMethodCondition;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;

class RuleBuilder {
    private final List<Action> actions = new ArrayList<Action>();
    private final List<Condition> conditions = new ArrayList<Condition>();
    private final UrlConditions urlConditions = new UrlConditions();

    RuleBuilder(String method, String defaultHost, String url) {
        UrlParser urlParser = new UrlParser();
        if (url.startsWith("/")) {
            url = defaultHost + url;
        }
        this.addCondition(new HttpMethodCondition(method));
        this.addUrlConditions(urlParser.parse(url));
    }

    RuleBuilder(String method) {
        this.addCondition(new HttpMethodCondition(method));
    }

    void addAction(Action o) {
        this.actions.add(o);
    }

    void addCondition(Condition o) {
        this.conditions.add(o);
    }

    private void addUrlConditions(UrlConditions newUrlConditions) {
        this.urlConditions.join(newUrlConditions);
    }

    void addParameterCondition(String name, Matcher<String> matcher) {
        UrlConditions urlConditions = new UrlConditions();
        urlConditions.getParameterConditions().put(name, matcher);
        this.addUrlConditions(urlConditions);
    }

    void addReferenceCondition(Matcher<String> matcher) {
        UrlConditions urlConditions = new UrlConditions();
        urlConditions.setReferenceConditions(matcher);
        this.addUrlConditions(urlConditions);
    }

    void addHostCondition(String host) {
        UrlParser urlParser = new UrlParser();
        UrlConditions urlConditions = new UrlConditions();
        urlConditions.setHostConditions(urlParser.parse(host).getHostConditions());
        this.addUrlConditions(urlConditions);
    }

    void addPathCondition(Matcher<String> matcher) {
        UrlConditions urlConditions = new UrlConditions();
        urlConditions.getPathConditions().add(matcher);
        this.addUrlConditions(urlConditions);
    }

    Action getLastAction() {
        return this.actions.get(this.actions.size() - 1);
    }

    void overrideLastAction(Action lastAction) {
        this.actions.set(this.actions.size() - 1, lastAction);
    }

    Rule toRule() {
        return new Rule(this.urlConditions, this.conditions, this.actions);
    }
}

