/*
 * Decompiled with CFR 0.152.
 */
package com.github.paweladamski.httpclientmock.condition;

import com.github.paweladamski.httpclientmock.Debugger;
import com.github.paweladamski.httpclientmock.Request;
import com.github.paweladamski.httpclientmock.condition.Condition;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;

public class HeaderCondition
implements Condition {
    private final String header;
    private final Matcher<String> value;

    public HeaderCondition(String header, Matcher<String> value) {
        this.header = header;
        this.value = value;
    }

    @Override
    public boolean matches(Request request) {
        return request.getHttpRequest().getFirstHeader(this.header) != null && this.value.matches((Object)request.getHttpRequest().getFirstHeader(this.header).getValue());
    }

    @Override
    public void debug(Request request, Debugger debugger) {
        String matcherDesc = StringDescription.toString(this.value);
        debugger.message(this.matches(request), "header " + this.header + " is " + matcherDesc);
    }
}

