/*
 * Decompiled with CFR 0.152.
 */
package com.github.paweladamski.httpclientmock.matchers;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.http.HttpResponse;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public final class HttpResponseMatchers {
    public static Matcher<? super HttpResponse> hasStatus(final int expectedStatus) {
        return new BaseMatcher<HttpResponse>(){

            public boolean matches(Object o) {
                HttpResponse response = (HttpResponse)o;
                return response.getStatusLine().getStatusCode() == expectedStatus;
            }

            public void describeTo(Description description) {
                description.appendValue((Object)expectedStatus);
            }
        };
    }

    public static Matcher<? super HttpResponse> hasContent(String content) {
        return HttpResponseMatchers.hasContent(content, "UTF-8");
    }

    public static Matcher<? super HttpResponse> hasContent(final String content, final String charset) {
        return new BaseMatcher<HttpResponse>(){

            public boolean matches(Object o) {
                try {
                    int intValueOfChar;
                    HttpResponse response = (HttpResponse)o;
                    InputStreamReader reader = new InputStreamReader(response.getEntity().getContent(), charset);
                    String targetString = "";
                    while ((intValueOfChar = ((Reader)reader).read()) != -1) {
                        targetString = targetString + (char)intValueOfChar;
                    }
                    ((Reader)reader).close();
                    return targetString.equals(content);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
            }

            public void describeTo(Description description) {
                description.appendText(content);
            }
        };
    }
}

