/*
 * Decompiled with CFR 0.152.
 */
package com.github.paweladamski.httpclientmock;

import com.github.paweladamski.httpclientmock.HttpClientResponseBuilder;
import com.github.paweladamski.httpclientmock.RuleBuilder;
import com.github.paweladamski.httpclientmock.action.Action;
import com.github.paweladamski.httpclientmock.condition.BodyMatcher;
import com.github.paweladamski.httpclientmock.condition.Condition;
import com.github.paweladamski.httpclientmock.condition.HeaderCondition;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.http.entity.ContentType;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class HttpClientMockBuilder {
    private final RuleBuilder ruleBuilder;
    private final HttpClientResponseBuilder responseBuilder;

    HttpClientMockBuilder(RuleBuilder rule) {
        this.ruleBuilder = rule;
        this.responseBuilder = new HttpClientResponseBuilder(rule);
    }

    public HttpClientMockBuilder withHeader(String header, String value) {
        return this.withHeader(header, (Matcher<String>)Matchers.equalTo((Object)value));
    }

    public HttpClientMockBuilder withHeader(String header, Matcher<String> matcher) {
        this.ruleBuilder.addCondition(new HeaderCondition(header, matcher));
        return this;
    }

    public HttpClientMockBuilder withReference(String reference) {
        return this.withReference((Matcher<String>)Matchers.equalTo((Object)reference));
    }

    public HttpClientMockBuilder withReference(Matcher<String> matcher) {
        this.ruleBuilder.addReferenceCondition(matcher);
        return this;
    }

    public HttpClientMockBuilder withParameter(String name, String value) {
        return this.withParameter(name, (Matcher<String>)Matchers.equalTo((Object)value));
    }

    public HttpClientMockBuilder withParameter(String name, Matcher<String> matcher) {
        this.ruleBuilder.addParameterCondition(name, matcher);
        return this;
    }

    public HttpClientMockBuilder with(Condition condition) {
        this.ruleBuilder.addCondition(condition);
        return this;
    }

    public HttpClientMockBuilder withBody(Matcher<String> matcher) {
        this.ruleBuilder.addCondition(new BodyMatcher(matcher));
        return this;
    }

    public HttpClientMockBuilder withHost(String host) {
        this.ruleBuilder.addHostCondition(host);
        return this;
    }

    public HttpClientMockBuilder withPath(String path) {
        return this.withPath((Matcher<String>)Matchers.equalTo((Object)path));
    }

    public HttpClientMockBuilder withPath(Matcher<String> matcher) {
        this.ruleBuilder.addPathCondition(matcher);
        return this;
    }

    public HttpClientResponseBuilder doAction(Action action) {
        return this.responseBuilder.doAction(action);
    }

    public HttpClientResponseBuilder doReturn(String response) {
        return this.responseBuilder.doReturn(response);
    }

    public HttpClientResponseBuilder doReturn(int statusCode, String response) {
        return this.responseBuilder.doReturn(statusCode, response);
    }

    public HttpClientResponseBuilder doReturn(String response, Charset charset) {
        return this.responseBuilder.doReturn(response, charset);
    }

    public HttpClientResponseBuilder doReturn(int statusCode, String response, Charset charset) {
        return this.responseBuilder.doReturn(statusCode, response, charset);
    }

    public HttpClientResponseBuilder doReturn(String response, Charset charset, ContentType contentType) {
        return this.responseBuilder.doReturn(response, charset, contentType);
    }

    public HttpClientResponseBuilder doReturnStatus(int statusCode) {
        return this.responseBuilder.doReturnStatus(statusCode);
    }

    public HttpClientResponseBuilder doThrowException(IOException exception) {
        return this.responseBuilder.doThrowException(exception);
    }

    public HttpClientResponseBuilder doReturnJSON(String response) {
        return this.responseBuilder.doReturnJSON(response);
    }

    public HttpClientResponseBuilder doReturnJSON(String response, Charset charset) {
        return this.responseBuilder.doReturnJSON(response, charset);
    }

    public HttpClientResponseBuilder doReturnXML(String response) {
        return this.responseBuilder.doReturnXML(response);
    }

    public HttpClientResponseBuilder doReturnXML(String response, Charset charset) {
        return this.responseBuilder.doReturnXML(response, charset);
    }
}

