/*
 * Decompiled with CFR 0.152.
 */
package com.github.paweladamski.httpclientmock;

import com.github.paweladamski.httpclientmock.HttpClientVerifyBuilder;
import com.github.paweladamski.httpclientmock.Request;
import com.github.paweladamski.httpclientmock.RuleBuilder;
import java.util.List;

public class HttpClientVerify {
    private final String defaultHost;
    private final List<Request> requests;

    public HttpClientVerify(String defaultHost, List<Request> requests) {
        this.requests = requests;
        this.defaultHost = defaultHost;
    }

    private HttpClientVerifyBuilder newRule(String method) {
        RuleBuilder r = new RuleBuilder(method);
        return new HttpClientVerifyBuilder(r, this.requests);
    }

    private HttpClientVerifyBuilder newRule(String method, String url) {
        RuleBuilder r = new RuleBuilder(method, this.defaultHost, url);
        return new HttpClientVerifyBuilder(r, this.requests);
    }

    public HttpClientVerifyBuilder post(String url) {
        return this.newRule("POST", url);
    }

    public HttpClientVerifyBuilder get(String url) {
        return this.newRule("GET", url);
    }

    public HttpClientVerifyBuilder put(String url) {
        return this.newRule("PUT", url);
    }

    public HttpClientVerifyBuilder delete(String url) {
        return this.newRule("DELETE", url);
    }

    public HttpClientVerifyBuilder head(String url) {
        return this.newRule("HEAD", url);
    }

    public HttpClientVerifyBuilder options(String url) {
        return this.newRule("OPTIONS", url);
    }

    public HttpClientVerifyBuilder patch(String url) {
        return this.newRule("PATCH", url);
    }

    public HttpClientVerifyBuilder post() {
        return this.newRule("POST");
    }

    public HttpClientVerifyBuilder get() {
        return this.newRule("GET");
    }

    public HttpClientVerifyBuilder put() {
        return this.newRule("PUT");
    }

    public HttpClientVerifyBuilder delete() {
        return this.newRule("DELETE");
    }

    public HttpClientVerifyBuilder head() {
        return this.newRule("HEAD");
    }

    public HttpClientVerifyBuilder options() {
        return this.newRule("OPTIONS");
    }

    public HttpClientVerifyBuilder patch() {
        return this.newRule("PATCH");
    }
}

