/*
 * Decompiled with CFR 0.152.
 */
package com.github.paweladamski.httpclientmock;

import com.github.paweladamski.httpclientmock.Request;
import com.github.paweladamski.httpclientmock.Rule;
import com.github.paweladamski.httpclientmock.RuleBuilder;
import com.github.paweladamski.httpclientmock.condition.BodyMatcher;
import com.github.paweladamski.httpclientmock.condition.Condition;
import com.github.paweladamski.httpclientmock.condition.HeaderCondition;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class HttpClientVerifyBuilder {
    private final RuleBuilder ruleBuilder;
    private final List<Request> requests;

    HttpClientVerifyBuilder(RuleBuilder ruleBuilder, List<Request> requests) {
        this.requests = requests;
        this.ruleBuilder = ruleBuilder;
    }

    public HttpClientVerifyBuilder withHeader(String header, String value) {
        return this.withHeader(header, (Matcher<String>)Matchers.equalTo((Object)value));
    }

    public HttpClientVerifyBuilder withHeader(String header, Matcher<String> matcher) {
        this.ruleBuilder.addCondition(new HeaderCondition(header, matcher));
        return this;
    }

    public HttpClientVerifyBuilder withReference(String reference) {
        return this.withReference((Matcher<String>)Matchers.equalTo((Object)reference));
    }

    public HttpClientVerifyBuilder withReference(Matcher<String> matcher) {
        this.ruleBuilder.addReferenceCondition(matcher);
        return this;
    }

    public HttpClientVerifyBuilder withParameter(String name, String value) {
        return this.withParameter(name, (Matcher<String>)Matchers.equalTo((Object)value));
    }

    public HttpClientVerifyBuilder withParameter(String name, Matcher<String> matcher) {
        this.ruleBuilder.addParameterCondition(name, matcher);
        return this;
    }

    public HttpClientVerifyBuilder with(Condition condition) {
        this.ruleBuilder.addCondition(condition);
        return this;
    }

    public HttpClientVerifyBuilder withBody(Matcher<String> matcher) {
        this.ruleBuilder.addCondition(new BodyMatcher(matcher));
        return this;
    }

    public HttpClientVerifyBuilder withHost(String host) {
        this.ruleBuilder.addHostCondition(host);
        return this;
    }

    public HttpClientVerifyBuilder withPath(String path) {
        return this.withPath((Matcher<String>)Matchers.equalTo((Object)path));
    }

    public HttpClientVerifyBuilder withPath(Matcher<String> matcher) {
        this.ruleBuilder.addPathCondition(matcher);
        return this;
    }

    public void notCalled() {
        this.called(0);
    }

    public void called() {
        this.called(1);
    }

    public void called(int numberOfCalls) {
        this.called((Matcher<Integer>)Matchers.equalTo((Object)numberOfCalls));
    }

    public void called(Matcher<Integer> numberOfCalls) {
        Rule rule = this.ruleBuilder.toRule();
        int matchingCalls = (int)this.requests.stream().filter(rule::matches).count();
        if (!numberOfCalls.matches((Object)matchingCalls)) {
            throw new IllegalStateException(String.format("Expected %s calls, but found %s.", numberOfCalls, matchingCalls));
        }
    }
}

