/*
 * Decompiled with CFR 0.152.
 */
package com.github.paweladamski.httpclientmock;

import com.github.paweladamski.httpclientmock.Debugger;
import com.github.paweladamski.httpclientmock.Request;
import com.github.paweladamski.httpclientmock.UrlConditions;
import com.github.paweladamski.httpclientmock.action.Action;
import com.github.paweladamski.httpclientmock.action.StatusResponse;
import com.github.paweladamski.httpclientmock.condition.Condition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;

public class Rule {
    public static final Rule NOT_FOUND = new Rule(new UrlConditions(), Collections.emptyList(), Rule.notFoundAction());
    private final LinkedList<Action> actions;
    private final List<Condition> conditions;
    private final UrlConditions urlConditions;

    public Rule(UrlConditions urlConditions, List<Condition> conditions, List<Action> actions) {
        this.urlConditions = urlConditions;
        this.conditions = conditions;
        this.actions = new LinkedList<Action>(actions);
    }

    boolean matches(Request request) {
        return this.matches(request.getHttpHost(), request.getHttpRequest(), request.getHttpContext());
    }

    boolean matches(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) {
        return this.urlConditions.matches(httpRequest.getRequestLine().getUri()) && this.conditions.stream().allMatch(c -> c.matches(httpHost, httpRequest, httpContext));
    }

    HttpResponse nextResponse(Request request) throws IOException {
        Action action = this.actions.size() > 1 ? this.actions.poll() : this.actions.peek();
        return action.getResponse(request);
    }

    public void debug(Request request, Debugger debugger) {
        for (Condition condition : this.conditions) {
            condition.debug(request, debugger);
        }
        this.urlConditions.debug(request, debugger);
    }

    private static List<Action> notFoundAction() {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(new StatusResponse(404));
        return actions;
    }
}

