/*
 * Decompiled with CFR 0.152.
 */
package com.github.paweladamski.httpclientmock;

import com.github.paweladamski.httpclientmock.Debugger;
import com.github.paweladamski.httpclientmock.Request;
import com.github.paweladamski.httpclientmock.UrlParams;
import com.github.paweladamski.httpclientmock.matchers.MatchersList;
import com.github.paweladamski.httpclientmock.matchers.MatchersMap;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.http.NameValuePair;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.StringDescription;

public class UrlConditions {
    private static final int EMPTY_PORT = -1;
    private MatchersMap<String, String> parameterConditions = new MatchersMap();
    private Matcher<String> referenceConditions = Matchers.isEmptyOrNullString();
    private MatchersList<String> hostConditions = new MatchersList();
    private MatchersList<String> pathConditions = new MatchersList();
    private MatchersList<Integer> portConditions = new MatchersList();
    private Matcher<String> schemaConditions = Matchers.any(String.class);

    public MatchersMap<String, String> getParameterConditions() {
        return this.parameterConditions;
    }

    public Matcher<String> getReferenceConditions() {
        return this.referenceConditions;
    }

    public void setReferenceConditions(Matcher<String> referenceConditions) {
        this.referenceConditions = referenceConditions;
    }

    public MatchersList<String> getHostConditions() {
        return this.hostConditions;
    }

    public void setHostConditions(MatchersList<String> hostConditions) {
        this.hostConditions = hostConditions;
    }

    public MatchersList<String> getPathConditions() {
        return this.pathConditions;
    }

    public MatchersList<Integer> getPortConditions() {
        return this.portConditions;
    }

    public void setSchemaConditions(Matcher<String> schemaConditions) {
        this.schemaConditions = schemaConditions;
    }

    boolean matches(String urlText) {
        try {
            URL url = new URL(urlText);
            return this.hostConditions.allMatches(url.getHost()) && this.pathConditions.allMatches(url.getPath()) && this.portConditions.allMatches(url.getPort()) && this.referenceConditions.matches((Object)url.getRef()) && this.schemaConditions.matches((Object)url.getProtocol()) && this.allDefinedParamsOccurredInURL(url.getQuery()) && this.allParamsHaveMatchingValue(url.getQuery());
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    private boolean allDefinedParamsOccurredInURL(String query) {
        return this.findMissingParameters(query).isEmpty();
    }

    private boolean allParamsHaveMatchingValue(String query) {
        UrlParams params = UrlParams.parse(query);
        return params.stream().allMatch(param -> this.parameterConditions.matches(param.getName(), param.getValue()));
    }

    private Set<String> findMissingParameters(String query) {
        UrlParams params = UrlParams.parse(query);
        return this.parameterConditions.keySet().stream().filter(((Predicate<String>)params::contain).negate()).collect(Collectors.toSet());
    }

    public void join(UrlConditions a) {
        this.referenceConditions = a.referenceConditions;
        this.schemaConditions = a.schemaConditions;
        this.portConditions.addAll(a.portConditions);
        this.pathConditions.addAll(a.pathConditions);
        this.hostConditions.addAll(a.hostConditions);
        for (String paramName : a.parameterConditions.keySet()) {
            for (Matcher paramValue : (MatchersList)a.parameterConditions.get(paramName)) {
                this.parameterConditions.put(paramName, (Matcher<String>)paramValue);
            }
        }
    }

    void debug(Request request, Debugger debugger) {
        try {
            URL url = new URL(request.getUri());
            debugger.message(this.hostConditions.allMatches(url.getHost()), "schema is " + this.describe(this.schemaConditions));
            debugger.message(this.hostConditions.allMatches(url.getHost()), "host is " + this.hostConditions.describe());
            debugger.message(this.pathConditions.allMatches(url.getPath()), "path is " + this.pathConditions.describe());
            debugger.message(this.portConditions.allMatches(url.getPort()), "port is " + this.portDebugDescription());
            if (this.referenceConditions != Matchers.isEmptyOrNullString() || !this.referenceConditions.matches((Object)url.getRef())) {
                debugger.message(this.referenceConditions.matches((Object)url.getRef()), "reference is " + this.describe(this.referenceConditions));
            }
            Set<String> missingParams = this.findMissingParameters(url.getQuery());
            for (String param : missingParams) {
                debugger.message(false, "parameter " + param + " occurs in request");
            }
            UrlParams params = UrlParams.parse(url.getQuery());
            for (NameValuePair param : params) {
                if (this.parameterConditions.containsKey(param.getName())) {
                    boolean matches = this.parameterConditions.matches(param.getName(), param.getValue());
                    String message = "parameter " + param.getName() + " is " + this.parameterConditions.describe(param.getName());
                    debugger.message(matches, message);
                    continue;
                }
                String message = "parameter " + param.getName() + " is redundant";
                debugger.message(false, message);
            }
        }
        catch (MalformedURLException e) {
            System.out.println("Can't parse URL: " + request.getUri());
        }
    }

    private String describe(Matcher<String> matcher) {
        return StringDescription.toString(matcher);
    }

    private String portDebugDescription() {
        if (this.portConditions.allMatches(-1)) {
            return "empty";
        }
        return this.portConditions.describe();
    }
}

