/*
 * Decompiled with CFR 0.152.
 */
package com.github.paweladamski.httpclientmock;

import com.github.paweladamski.httpclientmock.UrlConditions;
import com.github.paweladamski.httpclientmock.UrlParams;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.apache.http.NameValuePair;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class UrlParser {
    public static final int EMPTY_PORT_NUMBER = -1;

    public UrlConditions parse(String urlText) {
        try {
            UrlConditions conditions = new UrlConditions();
            URL url = new URL(urlText);
            if (url.getRef() != null) {
                conditions.setReferenceConditions((Matcher<String>)Matchers.equalTo((Object)url.getRef()));
            } else {
                conditions.setReferenceConditions((Matcher<String>)Matchers.isEmptyOrNullString());
            }
            conditions.setSchemaConditions((Matcher<String>)Matchers.equalTo((Object)url.getProtocol()));
            conditions.getHostConditions().add(Matchers.equalTo((Object)url.getHost()));
            conditions.getPortConditions().add(Matchers.equalTo((Object)url.getPort()));
            conditions.getPathConditions().add(Matchers.equalTo((Object)url.getPath()));
            UrlParams params = UrlParams.parse(url.getQuery(), StandardCharsets.UTF_8);
            for (NameValuePair param : params) {
                conditions.getParameterConditions().put(param.getName(), (Matcher<String>)Matchers.equalTo((Object)param.getValue()));
            }
            return conditions;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

