/*
 * Decompiled with CFR 0.152.
 */
package com.github.paweladamski.httpclientmock;

import com.github.paweladamski.httpclientmock.Debugger;
import com.github.paweladamski.httpclientmock.HttpClientMockBuilder;
import com.github.paweladamski.httpclientmock.HttpClientVerify;
import com.github.paweladamski.httpclientmock.HttpResponseProxy;
import com.github.paweladamski.httpclientmock.Request;
import com.github.paweladamski.httpclientmock.Rule;
import com.github.paweladamski.httpclientmock.RuleBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

public class HttpClientMock
extends CloseableHttpClient {
    private final HttpParams params = new BasicHttpParams();
    private final Debugger debugger;
    private final List<RuleBuilder> rulesUnderConstruction = new ArrayList<RuleBuilder>();
    private final List<Rule> rules = new ArrayList<Rule>();
    private final String defaultHost;
    private final List<Request> requests = new ArrayList<Request>();
    private boolean isDebuggingTurnOn = false;
    private final List<HttpRequestInterceptor> requestInterceptors = new ArrayList<HttpRequestInterceptor>();
    private final List<HttpResponseInterceptor> responseInterceptors = new ArrayList<HttpResponseInterceptor>();

    public HttpClientMock() {
        this("");
    }

    public HttpClientMock(String defaultHost) {
        this(defaultHost, new Debugger());
    }

    HttpClientMock(String defaultHost, Debugger debugger) {
        this.defaultHost = defaultHost;
        this.debugger = debugger;
    }

    public void reset() {
        this.rulesUnderConstruction.clear();
        this.rules.clear();
        this.requests.clear();
    }

    public HttpClientVerify verify() {
        return new HttpClientVerify(this.defaultHost, this.requests);
    }

    public HttpClientMockBuilder onPost() {
        return this.newRule("POST");
    }

    public HttpClientMockBuilder onGet() {
        return this.newRule("GET");
    }

    public HttpClientMockBuilder onDelete() {
        return this.newRule("DELETE");
    }

    public HttpClientMockBuilder onHead() {
        return this.newRule("HEAD");
    }

    @Deprecated
    public HttpClientMockBuilder onOption() {
        return this.onOptions();
    }

    public HttpClientMockBuilder onOptions() {
        return this.newRule("OPTIONS");
    }

    public HttpClientMockBuilder onPut() {
        return this.newRule("PUT");
    }

    public HttpClientMockBuilder onPatch() {
        return this.newRule("PATCH");
    }

    public HttpClientMockBuilder onGet(String url) {
        return this.newRule("GET", url);
    }

    public HttpClientMockBuilder onPost(String url) {
        return this.newRule("POST", url);
    }

    public HttpClientMockBuilder onPut(String url) {
        return this.newRule("PUT", url);
    }

    public HttpClientMockBuilder onDelete(String url) {
        return this.newRule("DELETE", url);
    }

    public HttpClientMockBuilder onHead(String url) {
        return this.newRule("HEAD", url);
    }

    public HttpClientMockBuilder onOptions(String url) {
        return this.newRule("OPTIONS", url);
    }

    public HttpClientMockBuilder onPatch(String url) {
        return this.newRule("PATCH", url);
    }

    private HttpClientMockBuilder newRule(String method) {
        RuleBuilder r = new RuleBuilder(method);
        this.rulesUnderConstruction.add(r);
        return new HttpClientMockBuilder(r);
    }

    private HttpClientMockBuilder newRule(String method, String url) {
        RuleBuilder r = new RuleBuilder(method, this.defaultHost, url);
        this.rulesUnderConstruction.add(r);
        return new HttpClientMockBuilder(r);
    }

    protected CloseableHttpResponse doExecute(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) throws IOException {
        this.finishBuildingRules();
        this.executeRequestInterceptors(httpRequest, httpContext);
        HttpResponse response = this.getHttpResponse(httpHost, httpRequest, httpContext);
        this.executeResponseInterceptors(httpContext, response);
        return new HttpResponseProxy(response);
    }

    private void executeResponseInterceptors(HttpContext httpContext, HttpResponse response) throws IOException {
        try {
            for (HttpResponseInterceptor responseInterceptor : this.responseInterceptors) {
                responseInterceptor.process(response, httpContext);
            }
        }
        catch (HttpException e) {
            throw new IOException(e);
        }
    }

    private HttpResponse getHttpResponse(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) throws IOException {
        Request request = new Request(httpHost, httpRequest, httpContext);
        this.requests.add(request);
        Rule rule = this.rules.stream().filter(r -> r.matches(httpHost, httpRequest, httpContext)).reduce((a, b) -> b).orElse(Rule.NOT_FOUND);
        if (this.isDebuggingTurnOn || rule == Rule.NOT_FOUND) {
            this.debugger.debug(this.rules, request);
        }
        return rule.nextResponse(request);
    }

    private void executeRequestInterceptors(HttpRequest httpRequest, HttpContext httpContext) throws IOException {
        try {
            for (HttpRequestInterceptor requestInterceptor : this.requestInterceptors) {
                requestInterceptor.process(httpRequest, httpContext);
            }
        }
        catch (HttpException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishBuildingRules() {
        List<RuleBuilder> list = this.rulesUnderConstruction;
        synchronized (list) {
            for (RuleBuilder ruleBuilder : this.rulesUnderConstruction) {
                this.rules.add(ruleBuilder.toRule());
            }
            this.rulesUnderConstruction.clear();
        }
    }

    public void close() throws IOException {
    }

    public HttpParams getParams() {
        return this.params;
    }

    public ClientConnectionManager getConnectionManager() {
        return null;
    }

    public void debugOn() {
        this.isDebuggingTurnOn = true;
    }

    public void debugOff() {
        this.isDebuggingTurnOn = false;
    }

    public void addRequestInterceptor(HttpRequestInterceptor requestInterceptor) {
        this.requestInterceptors.add(requestInterceptor);
    }

    public void addResponseInterceptor(HttpResponseInterceptor responseInterceptor) {
        this.responseInterceptors.add(responseInterceptor);
    }
}

