/*
 * Decompiled with CFR 0.152.
 */
package com.github.paweladamski.httpclientmock;

import com.github.paweladamski.httpclientmock.RuleBuilder;
import com.github.paweladamski.httpclientmock.action.Action;
import com.github.paweladamski.httpclientmock.action.CookieAction;
import com.github.paweladamski.httpclientmock.action.ExceptionAction;
import com.github.paweladamski.httpclientmock.action.HeaderAction;
import com.github.paweladamski.httpclientmock.action.StatusResponse;
import com.github.paweladamski.httpclientmock.action.StringResponse;
import com.github.paweladamski.httpclientmock.action.UrlEncodedFormEntityResponse;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import org.apache.http.NameValuePair;
import org.apache.http.entity.ContentType;

public class HttpClientResponseBuilder {
    private final RuleBuilder newRule;

    HttpClientResponseBuilder(RuleBuilder rule) {
        this.newRule = rule;
    }

    public HttpClientResponseBuilder withHeader(String name, String value) {
        Action lastAction = this.newRule.getLastAction();
        HeaderAction headerAction = new HeaderAction(lastAction, name, value);
        this.newRule.overrideLastAction(headerAction);
        return this;
    }

    public HttpClientResponseBuilder withStatus(int statusCode) {
        Action lastAction = this.newRule.getLastAction();
        StatusResponse statusAction = new StatusResponse(lastAction, statusCode);
        this.newRule.overrideLastAction(statusAction);
        return this;
    }

    public HttpClientResponseBuilder withCookie(String cookieName, String cookieValue) {
        Action lastAction = this.newRule.getLastAction();
        CookieAction cookieAction = new CookieAction(lastAction, cookieName, cookieValue);
        this.newRule.overrideLastAction(cookieAction);
        return this;
    }

    public HttpClientResponseBuilder doAction(Action action) {
        this.newRule.addAction(action);
        return new HttpClientResponseBuilder(this.newRule);
    }

    public HttpClientResponseBuilder doReturn(String response) {
        return this.doReturn(response, StandardCharsets.UTF_8);
    }

    public HttpClientResponseBuilder doReturn(int statusCode, String response) {
        return this.doReturn(statusCode, response, StandardCharsets.UTF_8);
    }

    public HttpClientResponseBuilder doReturn(String response, Charset charset) {
        this.newRule.addAction(new StringResponse(response, charset));
        return new HttpClientResponseBuilder(this.newRule);
    }

    public HttpClientResponseBuilder doReturn(String response, Charset charset, ContentType contentType) {
        this.newRule.addAction(new StringResponse(response, charset, contentType));
        return new HttpClientResponseBuilder(this.newRule);
    }

    public HttpClientResponseBuilder doReturn(int statusCode, String response, Charset charset) {
        this.newRule.addAction(new StringResponse(statusCode, response, charset));
        return new HttpClientResponseBuilder(this.newRule);
    }

    public HttpClientResponseBuilder doReturnStatus(int statusCode) {
        this.newRule.addAction(new StatusResponse(statusCode));
        return new HttpClientResponseBuilder(this.newRule);
    }

    public HttpClientResponseBuilder doThrowException(IOException exception) {
        this.newRule.addAction(new ExceptionAction(exception));
        return new HttpClientResponseBuilder(this.newRule);
    }

    public HttpClientResponseBuilder doReturnJSON(String response) {
        return this.doReturnJSON(response, StandardCharsets.UTF_8);
    }

    public HttpClientResponseBuilder doReturnJSON(String response, Charset charset) {
        return this.doReturn(response, charset, ContentType.APPLICATION_JSON);
    }

    public HttpClientResponseBuilder doReturnXML(String response) {
        return this.doReturnXML(response, StandardCharsets.UTF_8);
    }

    public HttpClientResponseBuilder doReturnXML(String response, Charset charset) {
        return this.doReturn(response, charset, ContentType.APPLICATION_XML);
    }

    public HttpClientResponseBuilder doReturnFormParams(Collection<NameValuePair> formParameters) {
        return this.doReturnFormParams(formParameters, StandardCharsets.UTF_8);
    }

    public HttpClientResponseBuilder doReturnFormParams(Collection<NameValuePair> formParameters, Charset charset) {
        this.newRule.addAction(new UrlEncodedFormEntityResponse(formParameters, charset));
        return new HttpClientResponseBuilder(this.newRule);
    }
}

