/*
 * Decompiled with CFR 0.152.
 */
package com.github.paweladamski.httpclientmock;

import com.github.paweladamski.httpclientmock.Rule;
import com.github.paweladamski.httpclientmock.UrlConditions;
import com.github.paweladamski.httpclientmock.UrlParser;
import com.github.paweladamski.httpclientmock.action.Action;
import com.github.paweladamski.httpclientmock.condition.Condition;
import com.github.paweladamski.httpclientmock.condition.HttpMethodCondition;
import com.github.paweladamski.httpclientmock.condition.UrlEncodedFormCondition;
import com.github.paweladamski.httpclientmock.matchers.ParametersMatcher;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;

class RuleBuilder {
    private final List<Action> actions = new ArrayList<Action>();
    private final List<Condition> conditions = new ArrayList<Condition>();
    private final UrlEncodedFormCondition formParametersCondition = new UrlEncodedFormCondition();
    private final UrlConditions urlConditions;

    RuleBuilder(String method, String defaultHost, String url) {
        this.urlConditions = new UrlParser().parse(this.buildFinalUrl(defaultHost, url));
        this.addCondition(new HttpMethodCondition(method));
        this.addCondition(this.formParametersCondition);
        this.setAllowExtraParameters(true);
        this.setAllowExtraFormParameters(true);
    }

    RuleBuilder(String method) {
        this.urlConditions = new UrlConditions();
        this.addCondition(new HttpMethodCondition(method));
        this.addCondition(this.formParametersCondition);
        this.setAllowExtraParameters(true);
        this.setAllowExtraFormParameters(true);
    }

    private String buildFinalUrl(String defaultHost, String url) {
        if (url.startsWith("/")) {
            return defaultHost + url;
        }
        return url;
    }

    void addAction(Action o) {
        this.actions.add(o);
    }

    void addCondition(Condition o) {
        this.conditions.add(o);
    }

    void addParameterCondition(String name, Matcher<String> matcher) {
        this.urlConditions.getUrlQueryConditions().put(name, matcher);
    }

    void addFormParameterCondition(String name, Matcher<String> matcher) {
        this.formParametersCondition.addExpectedParameter(name, matcher);
    }

    void addFormParameterConditions(ParametersMatcher parameters) {
        this.formParametersCondition.addExpectedParameters(parameters);
    }

    void addReferenceCondition(Matcher<String> matcher) {
        this.urlConditions.setReferenceConditions(matcher);
    }

    void addHostCondition(String host) {
        UrlParser urlParser = new UrlParser();
        this.urlConditions.setHostConditions(urlParser.parse(host).getHostConditions());
    }

    void addPathCondition(Matcher<String> matcher) {
        this.urlConditions.getPathConditions().add(matcher);
    }

    Action getLastAction() {
        return this.actions.get(this.actions.size() - 1);
    }

    void overrideLastAction(Action lastAction) {
        this.actions.set(this.actions.size() - 1, lastAction);
    }

    Rule toRule() {
        return new Rule(this.urlConditions, this.conditions, this.actions);
    }

    public void setAllowExtraParameters(boolean allowExtraParameters) {
        this.urlConditions.getUrlQueryConditions().setAllowExtraParameters(allowExtraParameters);
    }

    public void setAllowExtraFormParameters(boolean allowExtraFormParameters) {
        this.formParametersCondition.setAllowExtraParameters(allowExtraFormParameters);
    }
}

