/*
 * Decompiled with CFR 0.152.
 */
package com.github.paweladamski.httpclientmock;

import com.github.paweladamski.httpclientmock.Debugger;
import com.github.paweladamski.httpclientmock.Request;
import com.github.paweladamski.httpclientmock.matchers.MatchersList;
import com.github.paweladamski.httpclientmock.matchers.UrlQueryMatcher;
import java.net.MalformedURLException;
import java.net.URL;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.StringDescription;

public class UrlConditions {
    private static final int EMPTY_PORT = -1;
    private UrlQueryMatcher urlQueryConditions = new UrlQueryMatcher();
    private Matcher<String> referenceConditions = Matchers.isEmptyOrNullString();
    private MatchersList<String> hostConditions = new MatchersList();
    private MatchersList<String> pathConditions = new MatchersList();
    private MatchersList<Integer> portConditions = new MatchersList();
    private Matcher<String> schemaConditions = Matchers.any(String.class);

    public UrlQueryMatcher getUrlQueryConditions() {
        return this.urlQueryConditions;
    }

    public Matcher<String> getReferenceConditions() {
        return this.referenceConditions;
    }

    public void setReferenceConditions(Matcher<String> referenceConditions) {
        this.referenceConditions = referenceConditions;
    }

    public MatchersList<String> getHostConditions() {
        return this.hostConditions;
    }

    public void setHostConditions(MatchersList<String> hostConditions) {
        this.hostConditions = hostConditions;
    }

    public MatchersList<String> getPathConditions() {
        return this.pathConditions;
    }

    public MatchersList<Integer> getPortConditions() {
        return this.portConditions;
    }

    public void setSchemaConditions(Matcher<String> schemaConditions) {
        this.schemaConditions = schemaConditions;
    }

    boolean matches(String urlText) {
        try {
            URL url = new URL(urlText);
            return this.hostConditions.allMatches(url.getHost()) && this.pathConditions.allMatches(url.getPath()) && this.portConditions.allMatches(url.getPort()) && this.referenceConditions.matches((Object)url.getRef()) && this.schemaConditions.matches((Object)url.getProtocol()) && this.urlQueryConditions.matches(url.getQuery());
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    void debug(Request request, Debugger debugger) {
        try {
            URL url = new URL(request.getUri());
            debugger.message(this.hostConditions.allMatches(url.getHost()), "schema is " + this.describe(this.schemaConditions));
            debugger.message(this.hostConditions.allMatches(url.getHost()), "host is " + this.hostConditions.describe());
            debugger.message(this.pathConditions.allMatches(url.getPath()), "path is " + this.pathConditions.describe());
            debugger.message(this.portConditions.allMatches(url.getPort()), "port is " + this.portDebugDescription());
            if (this.referenceConditions != Matchers.isEmptyOrNullString() || !this.referenceConditions.matches((Object)url.getRef())) {
                debugger.message(this.referenceConditions.matches((Object)url.getRef()), "reference is " + this.describe(this.referenceConditions));
            }
            this.urlQueryConditions.describe(url.getQuery(), debugger);
        }
        catch (MalformedURLException e) {
            System.out.println("Can't parse URL: " + request.getUri());
        }
    }

    private String describe(Matcher<String> matcher) {
        return StringDescription.toString(matcher);
    }

    private String portDebugDescription() {
        return this.portConditions.allMatches(-1) ? "empty" : this.portConditions.describe();
    }
}

