/*
 * Decompiled with CFR 0.152.
 */
package com.github.paweladamski.httpclientmock;

import com.github.paweladamski.httpclientmock.UrlConditions;
import com.github.paweladamski.httpclientmock.UrlParamsParser;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.http.NameValuePair;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class UrlParser {
    public static final int EMPTY_PORT_NUMBER = -1;

    public UrlConditions parse(String urlText) {
        try {
            UrlConditions conditions = new UrlConditions();
            URL url = new URL(urlText);
            String ref = url.getRef();
            conditions.setReferenceConditions((Matcher<String>)(ref == null ? Matchers.isEmptyOrNullString() : Matchers.equalTo((Object)ref)));
            conditions.setSchemaConditions((Matcher<String>)Matchers.equalTo((Object)url.getProtocol()));
            conditions.getHostConditions().add(Matchers.equalTo((Object)url.getHost()));
            conditions.getPortConditions().add(Matchers.equalTo((Object)url.getPort()));
            conditions.getPathConditions().add(Matchers.equalTo((Object)url.getPath()));
            List<NameValuePair> params = new UrlParamsParser().parse(url.getQuery(), StandardCharsets.UTF_8);
            for (NameValuePair param : params) {
                conditions.getUrlQueryConditions().put(param.getName(), (Matcher<String>)Matchers.equalTo((Object)param.getValue()));
            }
            return conditions;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

