/*
 * Decompiled with CFR 0.152.
 */
package com.github.paweladamski.httpclientmock.action;

import com.github.paweladamski.httpclientmock.Request;
import com.github.paweladamski.httpclientmock.action.Action;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.cookie.BasicClientCookie;

public class CookieAction
implements Action {
    private final Action parentAction;
    private final String cookieName;
    private final String cookieValue;

    public CookieAction(Action parentAction, String cookieName, String cookieValue) {
        this.parentAction = parentAction;
        this.cookieName = cookieName;
        this.cookieValue = cookieValue;
    }

    @Override
    public HttpResponse getResponse(Request request) throws IOException {
        HttpResponse response = this.parentAction.getResponse(request);
        if (request.getHttpContext() == null) {
            throw new RuntimeException("No Http context");
        }
        if (!(request.getHttpContext() instanceof HttpClientContext)) {
            throw new RuntimeException("Http context is not a HttpClientContext instance.");
        }
        HttpClientContext httpClientContext = (HttpClientContext)request.getHttpContext();
        if (httpClientContext.getCookieStore() == null) {
            httpClientContext.setCookieStore((CookieStore)new BasicCookieStore());
        }
        httpClientContext.getCookieStore().addCookie((Cookie)new BasicClientCookie(this.cookieName, this.cookieValue));
        return response;
    }
}

