/*
 * Decompiled with CFR 0.152.
 */
package com.github.paweladamski.httpclientmock.action;

import com.github.paweladamski.httpclientmock.Request;
import com.github.paweladamski.httpclientmock.action.Action;
import java.io.IOException;
import java.util.Optional;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHttpResponse;

public class StatusResponse
implements Action {
    private final Optional<Action> parentAction;
    private final int status;

    public StatusResponse(int status) {
        this.status = status;
        this.parentAction = Optional.empty();
    }

    public StatusResponse(Action parentAction, int status) {
        this.status = status;
        this.parentAction = Optional.of(parentAction);
    }

    @Override
    public HttpResponse getResponse(Request request) throws IOException {
        HttpResponse response;
        if (this.parentAction.isPresent()) {
            response = this.parentAction.get().getResponse(request);
        } else {
            response = new BasicHttpResponse(new ProtocolVersion("http", 1, 1), this.status, "");
            if (this.status != 204) {
                response.setEntity((HttpEntity)new StringEntity(""));
            }
        }
        response.setStatusCode(this.status);
        return response;
    }
}

