/*
 * Decompiled with CFR 0.152.
 */
package com.github.paweladamski.httpclientmock.condition;

import com.github.paweladamski.httpclientmock.Debugger;
import com.github.paweladamski.httpclientmock.Request;
import com.github.paweladamski.httpclientmock.condition.Condition;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.util.EntityUtils;
import org.hamcrest.Matcher;

public class BodyMatcher
implements Condition {
    private final Matcher<String> matcher;

    public BodyMatcher(Matcher<String> matcher) {
        this.matcher = matcher;
    }

    @Override
    public boolean matches(Request request) {
        String message;
        HttpRequest httpRequest = request.getHttpRequest();
        if (!(httpRequest instanceof HttpEntityEnclosingRequest)) {
            return false;
        }
        HttpEntity entity = ((HttpEntityEnclosingRequest)httpRequest).getEntity();
        if (entity == null) {
            return false;
        }
        try {
            message = EntityUtils.toString((HttpEntity)entity);
        }
        catch (IOException e) {
            return false;
        }
        return this.matcher.matches((Object)message);
    }

    @Override
    public void debug(Request request, Debugger debugger) {
        debugger.message(this.matches(request), "body matches");
    }
}

