/*
 * Decompiled with CFR 0.152.
 */
package com.github.paweladamski.httpclientmock.condition;

import com.github.paweladamski.httpclientmock.Debugger;
import com.github.paweladamski.httpclientmock.Request;
import com.github.paweladamski.httpclientmock.condition.Condition;
import com.github.paweladamski.httpclientmock.condition.UrlEncodedFormParser;
import com.github.paweladamski.httpclientmock.matchers.ParametersMatcher;
import java.util.List;
import java.util.Set;
import org.apache.http.NameValuePair;
import org.hamcrest.Matcher;

public class UrlEncodedFormCondition
implements Condition {
    private ParametersMatcher expectedParameters = new ParametersMatcher();
    private boolean allowExtraParameters = false;

    @Override
    public boolean matches(Request r) {
        List<NameValuePair> actualParameters = new UrlEncodedFormParser().parse(r);
        if (this.allowExtraParameters) {
            return this.expectedParameters.matchesAndAllowExtraParameters(actualParameters);
        }
        return this.expectedParameters.matches(actualParameters);
    }

    public void addExpectedParameter(String name, Matcher<String> matcher) {
        this.expectedParameters.put(name, matcher);
    }

    public void addExpectedParameters(ParametersMatcher parameters) {
        this.expectedParameters.putAll(parameters);
    }

    @Override
    public void debug(Request r, Debugger debugger) {
        List<NameValuePair> actual = new UrlEncodedFormParser().parse(r);
        Set<String> missingParams = this.expectedParameters.findMissingParameters(actual);
        for (String string : missingParams) {
            debugger.message(false, "form parameter " + string + " is missing from the request");
        }
        for (NameValuePair nameValuePair : actual) {
            if (this.expectedParameters.containsParameter(nameValuePair.getName())) {
                boolean matches = this.expectedParameters.matches(nameValuePair.getName(), nameValuePair.getValue());
                String message = "form parameter " + nameValuePair.getName() + " is " + this.expectedParameters.get(nameValuePair.getName()).describe();
                debugger.message(matches, message);
                continue;
            }
            if (this.allowExtraParameters) continue;
            String message = "form parameter " + nameValuePair.getName() + " was not expected to be in the request";
            debugger.message(false, message);
        }
    }

    public void setAllowExtraParameters(boolean allowExtraParameters) {
        this.allowExtraParameters = allowExtraParameters;
    }
}

