/*
 * Decompiled with CFR 0.152.
 */
package com.github.paweladamski.httpclientmock.condition;

import com.github.paweladamski.httpclientmock.Request;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;

public class UrlEncodedFormParser {
    List<NameValuePair> parse(Request request) {
        if (!this.requestHasBody(request)) {
            return Collections.emptyList();
        }
        HttpEntityEnclosingRequest httpRequest = (HttpEntityEnclosingRequest)request.getHttpRequest();
        HttpEntity entity = httpRequest.getEntity();
        if (entity == null) {
            return Collections.emptyList();
        }
        try {
            return URLEncodedUtils.parse((HttpEntity)entity);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean requestHasBody(Request r) {
        return r.getHttpRequest() instanceof HttpEntityEnclosingRequest;
    }
}

