/*
 * Decompiled with CFR 0.152.
 */
package com.github.paweladamski.httpclientmock.matchers;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.util.EntityUtils;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public final class HttpResponseMatchers {
    public static Matcher<? super HttpResponse> hasStatus(final int expectedStatus) {
        return new BaseMatcher<HttpResponse>(){

            public boolean matches(Object o) {
                HttpResponse response = (HttpResponse)o;
                return response.getStatusLine().getStatusCode() == expectedStatus;
            }

            public void describeTo(Description description) {
                description.appendValue((Object)expectedStatus);
            }
        };
    }

    public static Matcher<? super HttpResponse> hasContent(String content) {
        return HttpResponseMatchers.hasContent(content, "UTF-8");
    }

    public static Matcher<? super HttpResponse> hasContent(final String content, final String charset) {
        return new BaseMatcher<HttpResponse>(){

            public boolean matches(Object o) {
                String targetString;
                HttpResponse response = (HttpResponse)o;
                try {
                    byte[] bytes = EntityUtils.toByteArray((HttpEntity)response.getEntity());
                    targetString = new String(bytes, charset);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
                return targetString.equals(content);
            }

            public void describeTo(Description description) {
                description.appendText(content);
            }
        };
    }

    public static Matcher<? super HttpClientContext> hasCookie(final String expectedCookieName, final String expectedCookieValue) {
        return new BaseMatcher<HttpClientContext>(){

            public boolean matches(Object o) {
                HttpClientContext httpClientContext = (HttpClientContext)o;
                String cookieValue = this.getCookieValue(httpClientContext.getCookieStore(), expectedCookieName);
                return expectedCookieValue.equals(cookieValue);
            }

            public void describeTo(Description description) {
                description.appendValue((Object)expectedCookieValue);
            }

            private String getCookieValue(CookieStore cookieStore, String cookieName) {
                if (cookieStore == null) {
                    return null;
                }
                return cookieStore.getCookies().stream().filter(c -> c.getName().equalsIgnoreCase(cookieName)).findFirst().map(c -> c.getValue()).orElse(null);
            }
        };
    }
}

