/*
 * Decompiled with CFR 0.152.
 */
package com.github.paweladamski.httpclientmock.matchers;

import com.github.paweladamski.httpclientmock.Debugger;
import com.github.paweladamski.httpclientmock.UrlParamsParser;
import com.github.paweladamski.httpclientmock.matchers.ParametersMatcher;
import java.util.List;
import java.util.Set;
import org.apache.http.NameValuePair;
import org.hamcrest.Matcher;

public class UrlQueryMatcher {
    private ParametersMatcher expected = new ParametersMatcher();
    private boolean allowExtraParameters;

    public boolean matches(String query) {
        List<NameValuePair> actualParameters = new UrlParamsParser().parse(query);
        if (this.allowExtraParameters) {
            return this.expected.matchesAndAllowExtraParameters(actualParameters);
        }
        return this.expected.matches(actualParameters);
    }

    public void put(String name, Matcher<String> matcher) {
        this.expected.put(name, matcher);
    }

    public void describe(String query, Debugger debugger) {
        List<NameValuePair> actualParameters = new UrlParamsParser().parse(query);
        Set<String> missingParams = this.expected.findMissingParameters(actualParameters);
        for (String string : missingParams) {
            debugger.message(false, "query parameter " + string + " is missing from the request");
        }
        for (NameValuePair nameValuePair : actualParameters) {
            if (this.expected.containsParameter(nameValuePair.getName())) {
                boolean matches = this.expected.matches(nameValuePair.getName(), nameValuePair.getValue());
                String message = "query parameter " + nameValuePair.getName() + " is " + this.expected.get(nameValuePair.getName()).describe();
                debugger.message(matches, message);
                continue;
            }
            if (this.allowExtraParameters) continue;
            String message = "query parameter " + nameValuePair.getName() + " was not expected to be in the request";
            debugger.message(false, message);
        }
    }

    public void setAllowExtraParameters(boolean allowExtraParameters) {
        this.allowExtraParameters = allowExtraParameters;
    }
}

