/*
 * Decompiled with CFR 0.152.
 */
package com.github.peacetrue.beanmap;

import com.github.peacetrue.beanmap.BeanMapUtils;
import com.github.peacetrue.beanmap.SupplierPropertyVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class DuplicatePropertyVisitor
implements SupplierPropertyVisitor<Map<String, Object>> {
    protected Map<String, Object> duplicate;

    public DuplicatePropertyVisitor(int size) {
        this(new LinkedHashMap<String, Object>(size));
    }

    public DuplicatePropertyVisitor(Map<String, Object> duplicate) {
        this.duplicate = Objects.requireNonNull(duplicate);
    }

    @Override
    public void visit(String name, @Nullable Object value) {
        this.duplicate.put(name, value);
    }

    @Override
    public void visit(String name, Map<String, Object> bean) {
        Map<String, Object> temp = this.duplicate;
        this.duplicate = this.prepareBean(name, bean.size());
        BeanMapUtils.walkTree(bean, this);
        this.duplicate = temp;
    }

    private Map<String, Object> prepareBean(String name, int size) {
        LinkedHashMap<String, Object> bean = new LinkedHashMap<String, Object>(size);
        this.duplicate.put(name, bean);
        return bean;
    }

    @Override
    public void visit(String name, Collection<Map<String, Object>> beans) {
        Map<String, Object> temp = this.duplicate;
        int i = 0;
        List<Map<String, Object>> duplicates = this.prepareBeans(name, beans.size());
        for (Map<String, Object> bean : beans) {
            this.visit(name, i++, bean);
            duplicates.add(this.duplicate);
        }
        this.duplicate = temp;
    }

    private List<Map<String, Object>> prepareBeans(String name, int size) {
        ArrayList<Map<String, Object>> beans = new ArrayList<Map<String, Object>>(size);
        this.duplicate.put(name, beans);
        return beans;
    }

    @Override
    public void visit(String name, int index, @Nullable Map<String, Object> bean) {
        if (bean == null) {
            this.duplicate = null;
        } else {
            this.duplicate = new LinkedHashMap<String, Object>(bean.size());
            BeanMapUtils.walkTree(bean, this);
        }
    }

    @Override
    public Map<String, Object> get() {
        return this.duplicate;
    }
}

