/*
 * Decompiled with CFR 0.152.
 */
package com.github.peacetrue.beanmap;

import com.github.peacetrue.beanmap.SupplierPropertyVisitor;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class FlatPropertyVisitor<T>
implements SupplierPropertyVisitor<Map<String, T>> {
    protected final Map<String, T> flat;
    protected String propertyPathPrefix = "";

    public FlatPropertyVisitor(int size) {
        this(new LinkedHashMap(size));
    }

    public FlatPropertyVisitor(Map<String, T> flat) {
        this.flat = Objects.requireNonNull(flat);
    }

    @Override
    public void visit(String name, @Nullable Object value) {
        this.flat.put(this.propertyPathPrefix + name, this.handleValue(value));
    }

    @Nullable
    protected T handleValue(@Nullable Object value) {
        return (T)value;
    }

    @Override
    public void visit(String name, Map<String, Object> bean) {
        String temp = this.propertyPathPrefix;
        this.propertyPathPrefix = FlatPropertyVisitor.buildBeanPropertyPathPrefix(this.propertyPathPrefix, name);
        SupplierPropertyVisitor.super.visit(name, bean);
        this.propertyPathPrefix = temp;
    }

    @Override
    public void visit(String name, int index, @Nullable Map<String, Object> bean) {
        String temp = this.propertyPathPrefix;
        this.propertyPathPrefix = FlatPropertyVisitor.buildBeansPropertyPathPrefix(this.propertyPathPrefix, name, index);
        SupplierPropertyVisitor.super.visit(name, index, bean);
        this.propertyPathPrefix = temp;
    }

    @Override
    public Map<String, T> get() {
        return this.flat;
    }

    private static String buildBeanPropertyPathPrefix(String propertyPathPrefix, String name) {
        return propertyPathPrefix + name + '.';
    }

    private static String buildBeansPropertyPathPrefix(String propertyPathPrefix, String name, int index) {
        return propertyPathPrefix + name + '[' + index + ']' + '.';
    }
}

