/*
 * Decompiled with CFR 0.152.
 */
package com.github.peacetrue.net;

import com.github.peacetrue.lang.UncheckedException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

public abstract class URLCodecUtils {
    private URLCodecUtils() {
    }

    public static String encode(String original) {
        return URLCodecUtils.encode(original, StandardCharsets.UTF_8.name());
    }

    public static String encode(String original, String charset) {
        try {
            return URLEncoder.encode(original, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new UncheckedException(e);
        }
    }

    public static String decode(String encoded) {
        return URLCodecUtils.decode(encoded, StandardCharsets.UTF_8.name());
    }

    public static String decode(String encoded, String charset) {
        try {
            return URLDecoder.decode(encoded, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new UncheckedException(e);
        }
    }
}

