/*
 * Decompiled with CFR 0.152.
 */
package com.github.peacetrue.range;

import com.github.peacetrue.range.ComparableRange;
import com.github.peacetrue.range.LocalDateTimeRange;
import com.github.peacetrue.range.Range;
import com.github.peacetrue.util.ObjectUtils;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalTime;

public class LocalDateRange
extends ComparableRange<LocalDate>
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final LocalDateRange DEFAULT = new LocalDateRange();

    public LocalDateRange(LocalDate bound) {
        super(bound);
    }

    public LocalDateRange(LocalDate lowerBound, LocalDate upperBound) {
        super(lowerBound, upperBound);
    }

    public LocalDateRange(LocalDate lowerBound, LocalDate upperBound, Boolean lowerInclusive, Boolean upperInclusive) {
        super(lowerBound, upperBound, lowerInclusive, upperInclusive);
    }

    public LocalDateRange(Range<LocalDate> range) {
        super(range);
    }

    public LocalDateTimeRange toLocalDateTimeRange() {
        LocalDateTimeRange range = new LocalDateTimeRange();
        range.setLowerInclusive(this.getLowerInclusive());
        range.setUpperInclusive(this.getUpperInclusive());
        ObjectUtils.acceptSafely(this.getLowerBound(), bound -> range.setLowerBound(bound.atTime(LocalTime.MIN)));
        ObjectUtils.acceptSafely(this.getUpperBound(), bound -> range.setUpperBound(bound.atTime(LocalTime.MAX)));
        return range;
    }

    public LocalDateRange() {
    }
}

