/*
 * Decompiled with CFR 0.152.
 */
package com.github.peacetrue.range;

import com.github.peacetrue.range.ComparableRange;
import com.github.peacetrue.range.Range;
import com.github.peacetrue.util.ObjectUtils;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.LocalTime;

public class LocalDateTimeRange
extends ComparableRange<LocalDateTime>
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final LocalDateTimeRange DEFAULT = new LocalDateTimeRange();

    public LocalDateTimeRange(LocalDateTime bound) {
        super(bound);
    }

    public LocalDateTimeRange(LocalDateTime lowerBound, LocalDateTime upperBound) {
        super(lowerBound, upperBound);
    }

    public LocalDateTimeRange(LocalDateTime lowerBound, LocalDateTime upperBound, Boolean lowerInclusive, Boolean upperInclusive) {
        super(lowerBound, upperBound, lowerInclusive, upperInclusive);
    }

    public LocalDateTimeRange(Range<LocalDateTime> range) {
        super(range);
    }

    public LocalDateTimeRange truncatedToDays() {
        LocalDateTimeRange range = new LocalDateTimeRange(this);
        LocalDateTimeRange.truncatedToDays(range);
        return range;
    }

    public static void truncatedToDays(LocalDateTimeRange range) {
        ObjectUtils.acceptSafely(range.getLowerBound(), bound -> range.setLowerBound(bound.with(LocalTime.MIN)));
        ObjectUtils.acceptSafely(range.getUpperBound(), bound -> range.setUpperBound(bound.with(LocalTime.MAX)));
    }

    public LocalDateTimeRange() {
    }
}

