/*
 * Decompiled with CFR 0.152.
 */
package com.github.peacetrue.range;

import com.github.peacetrue.range.ComparableRange;
import com.github.peacetrue.range.LocalDateTimeRange;
import com.github.peacetrue.range.Range;
import com.github.peacetrue.util.ObjectUtils;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;

public class LongRange
extends ComparableRange<Long>
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final LongRange DEFAULT = new LongRange();

    public LongRange(Long bound) {
        super(bound);
    }

    public LongRange(Long lowerBound, Long upperBound) {
        super(lowerBound, upperBound);
    }

    public LongRange(Long lowerBound, Long upperBound, Boolean lowerInclusive, Boolean upperInclusive) {
        super(lowerBound, upperBound, lowerInclusive, upperInclusive);
    }

    public LongRange(Range<Long> range) {
        super(range);
    }

    public LongRange increase(long increment) {
        LongRange range = new LongRange(this);
        LongRange.increase(range, increment);
        return range;
    }

    public static void increase(LongRange range, long increment) {
        ObjectUtils.acceptSafely(range.getLowerBound(), value -> range.setLowerBound(value + increment));
        ObjectUtils.acceptSafely(range.getUpperBound(), value -> range.setUpperBound(value + increment));
    }

    public Long getOffset() {
        return (Long)this.getUpperBound() - (Long)this.getLowerBound();
    }

    public LocalDateTimeRange toLocalDateTimeRange() {
        return this.toLocalDateTimeRange(ZoneId.systemDefault());
    }

    public LocalDateTimeRange toLocalDateTimeRange(ZoneId zoneId) {
        LocalDateTimeRange range = new LocalDateTimeRange();
        range.setLowerInclusive(this.getLowerInclusive());
        range.setUpperInclusive(this.getUpperInclusive());
        ObjectUtils.acceptSafely(this.getLowerBound(), bound -> range.setLowerBound(LongRange.toLocalDateTime(bound, zoneId)));
        ObjectUtils.acceptSafely(this.getUpperBound(), bound -> range.setUpperBound(LongRange.toLocalDateTime(bound, zoneId)));
        return range;
    }

    private static LocalDateTime toLocalDateTime(Long bound, ZoneId zoneId) {
        return Instant.ofEpochMilli(bound).atZone(zoneId).toLocalDateTime();
    }

    public LongRange() {
    }
}

