/*
 * Decompiled with CFR 0.152.
 */
package com.github.peacetrue.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;

public abstract class FileUtils {
    public static final String PARENT_RELATIVE_PATH = "..";
    public static final String CURRENT_RELATIVE_PATH = ".";

    private FileUtils() {
    }

    public static boolean isParentRelativePath(Path relativePath) {
        return relativePath.normalize().startsWith(PARENT_RELATIVE_PATH);
    }

    public static Path getRelativePath(Path basePath, Path absolutePath) {
        int endIndex;
        if (!absolutePath.startsWith(basePath)) {
            throw new IllegalArgumentException("absolutePath must be start with basePath");
        }
        int beginIndex = basePath.getNameCount();
        if (beginIndex == (endIndex = absolutePath.getNameCount())) {
            return Paths.get("", new String[0]);
        }
        return absolutePath.subpath(beginIndex, endIndex);
    }

    public static Path toPath(Object value) throws UnsupportedOperationException {
        if (value instanceof Path) {
            return (Path)value;
        }
        if (value instanceof String) {
            return Paths.get((String)value, new String[0]);
        }
        if (value instanceof File) {
            return ((File)value).toPath();
        }
        String message = "The value must be String or Path or File, Other type is not supported";
        throw new UnsupportedOperationException(message);
    }

    public static Path createFolderIfAbsent(Path path) throws IOException {
        return Files.exists(path, new LinkOption[0]) ? path : Files.createDirectories(path, new FileAttribute[0]);
    }

    public static Path createFile(Path path) throws IOException {
        Path parent = path.getParent();
        if (parent != null) {
            FileUtils.createFolderIfAbsent(parent);
        }
        return Files.createFile(path, new FileAttribute[0]);
    }

    public static Path createFileIfAbsent(Path path) throws IOException {
        return Files.exists(path, new LinkOption[0]) ? path : FileUtils.createFile(path);
    }

    public static Path createFileSafely(Path path) throws IOException {
        if (Files.notExists(path, new LinkOption[0])) {
            return FileUtils.createFile(path);
        }
        String fileName = path.getFileName().toString();
        int index = fileName.lastIndexOf(46);
        String name = index == -1 ? fileName : fileName.substring(0, index);
        String extension = index == -1 ? "" : '.' + fileName.substring(index + 1);
        int i = 0;
        while (Files.exists(path = path.resolveSibling(fileName = String.format("%s(%s)%s", name, ++i, extension)), new LinkOption[0])) {
        }
        return FileUtils.createFile(path);
    }

    public static DeletedCounts deleteRecursively(Path path) throws IOException {
        return FileUtils.deleteRecursively(path, new DeletedCounts());
    }

    public static DeletedCounts deleteRecursively(Path path, final DeletedCounts deletedCounts) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                deletedCounts.regularFile++;
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                deletedCounts.directoryFile++;
                return FileVisitResult.CONTINUE;
            }
        });
        return deletedCounts;
    }

    public static class DeletedCounts {
        private int regularFile;
        private int directoryFile;

        public DeletedCounts() {
            this(0, 0);
        }

        private DeletedCounts(int regularFile, int directoryFile) {
            this.regularFile = regularFile;
            this.directoryFile = directoryFile;
        }

        public DeletedCounts(DeletedCounts deletedCounts) {
            this.regularFile = deletedCounts.regularFile;
            this.directoryFile = deletedCounts.directoryFile;
        }

        public int getTotal() {
            return this.regularFile + this.directoryFile;
        }

        public DeletedCounts increase(DeletedCounts increment) {
            DeletedCounts deletedCounts = new DeletedCounts(this);
            DeletedCounts.increase(deletedCounts, increment);
            return deletedCounts;
        }

        public static void increase(DeletedCounts source, DeletedCounts increment) {
            source.regularFile += increment.regularFile;
            source.directoryFile += increment.directoryFile;
        }

        public int getRegularFile() {
            return this.regularFile;
        }

        public int getDirectoryFile() {
            return this.directoryFile;
        }

        public String toString() {
            return "FileUtils.DeletedCounts(regularFile=" + this.getRegularFile() + ", directoryFile=" + this.getDirectoryFile() + ")";
        }
    }
}

