/*
 * Decompiled with CFR 0.152.
 */
package com.github.peacetrue.util;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class MapUtils {
    private MapUtils() {
    }

    public static <K, V> Map<K, V> from(K[] keys, V[] values) {
        int length = Math.min(keys.length, values.length);
        LinkedHashMap map = new LinkedHashMap(length);
        IntStream.range(0, length).forEach(i -> map.put(keys[i], values[i]));
        return map;
    }

    @SafeVarargs
    public static <K, V> List<List<V>> values(Collection<Map<K, V>> maps, K ... keys) {
        return maps.stream().map(bean -> MapUtils.values(bean, keys)).collect(Collectors.toList());
    }

    @SafeVarargs
    public static <K, V> List<V> values(Map<K, V> map, K ... keys) {
        return Stream.of(keys).map(map::get).collect(Collectors.toList());
    }
}

