/*
 * Decompiled with CFR 0.152.
 */
package com.github.peacetrue.util;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class ObjectUtils {
    private ObjectUtils() {
    }

    public static <T> T defaultIfNull(T object, T defaultValue) {
        return object == null ? defaultValue : object;
    }

    public static <T> void acceptSafely(T value, Consumer<T> invoker) {
        if (value != null) {
            invoker.accept(value);
        }
    }

    @Nullable
    public static <T, S> S invokeSafely(T value, Function<T, S> invoker) {
        return ObjectUtils.invokeSafely(value, null, invoker);
    }

    public static <T, S> S invokeSafely(T value, S defaults, Function<T, S> invoker) {
        return value == null ? defaults : invoker.apply(value);
    }

    public static <T, S> S invokeSafelyLazily(T value, Supplier<S> defaults, Function<T, S> invoker) {
        return value == null ? defaults.get() : invoker.apply(value);
    }
}

