/*
 * Decompiled with CFR 0.152.
 */
package com.github.peacetrue.util.stream;

import com.github.peacetrue.util.ObjectUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public abstract class StreamUtils {
    private StreamUtils() {
    }

    public static <T> Stream<T> toStreamSafely(@Nullable Object data) {
        return StreamUtils.toStreamSafely(data, Stream.empty(), temp -> Stream.of(temp));
    }

    public static <T> Stream<T> toStreamSafely(@Nullable Object data, Stream<T> defaults, Function<Object, Stream<T>> converter) {
        return ObjectUtils.invokeSafely(data, defaults, temp -> StreamUtils.toStream(temp, converter));
    }

    public static <T> Stream<T> toStreamSafelyLazily(@Nullable Object data, Supplier<Stream<T>> defaults, Function<Object, Stream<T>> converter) {
        return ObjectUtils.invokeSafelyLazily(data, defaults, temp -> StreamUtils.toStream(temp, converter));
    }

    public static <T> Stream<T> toStream(Object streamable) throws UnsupportedOperationException {
        return StreamUtils.toStream(streamable, temp -> {
            String message = "Parameter streamable must be one of Stream, Object[], Collection, Iterator, Iterable, Type " + streamable.getClass().getName() + " is not supported";
            throw new UnsupportedOperationException(message);
        });
    }

    public static <T> Stream<T> toStream(Object data, Function<Object, Stream<T>> converter) {
        Objects.requireNonNull(data, "data must not be null");
        if (data instanceof Collection) {
            return ((Collection)data).stream();
        }
        if (data instanceof Object[]) {
            return Stream.of((Object[])data);
        }
        if (data instanceof Iterable) {
            return StreamUtils.iteratorStream(((Iterable)data).iterator());
        }
        if (data instanceof Iterator) {
            return StreamUtils.iteratorStream((Iterator)data);
        }
        if (data instanceof Stream) {
            return (Stream)data;
        }
        return converter.apply(data);
    }

    public static <T> Stream<T> iteratorStream(Iterator<T> iterator) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 0), false);
    }
}

