/*
 * Decompiled with CFR 0.152.
 */
package com.github.peacetrue.bean;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.ValueRange;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class BeanUtils {
    public static final char BEAN_SEPARATOR = '.';
    public static final char LIST_START_SEPARATOR = '[';
    public static final char LIST_END_SEPARATOR = ']';
    private static final Collection<Class<?>> PRIMITIVE_WRAPPERS = Collections.unmodifiableList(Arrays.asList(Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Void.class));
    private static final List<Class<?>> SIMPLE_VALUE_TYPES = Collections.unmodifiableList(Arrays.asList(CharSequence.class, Date.class, Enum.class, URI.class, URL.class, Locale.class, TemporalField.class, ValueRange.class, TemporalAccessor.class));

    private BeanUtils() {
    }

    public static boolean isPrimitiveWrapper(Class<?> clazz) {
        return PRIMITIVE_WRAPPERS.contains(clazz);
    }

    public static boolean isPrimitiveOrWrapper(Class<?> clazz) {
        return clazz.isPrimitive() || BeanUtils.isPrimitiveWrapper(clazz);
    }

    public static boolean isSimpleValueType(Class<?> clazz) {
        return BeanUtils.isPrimitiveOrWrapper(clazz) || BeanUtils.isSubclassOf(clazz, SIMPLE_VALUE_TYPES.stream());
    }

    public static boolean isSubclassOf(Class<?> subclass, Class<?> ... superclasses) {
        return BeanUtils.isSubclassOf(subclass, Stream.of(superclasses));
    }

    public static boolean isSubclassOf(Class<?> subclass, Stream<Class<?>> superclasses) {
        return superclasses.anyMatch(clazz2 -> clazz2.isAssignableFrom(subclass));
    }

    static BeanInfo getBeanInfo(Class<?> clazz) {
        try {
            return Introspector.getBeanInfo(clazz, Object.class);
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> T instance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Object invoke(Object object, Method method) {
        try {
            return method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void invoke(Object object, Method method, Object propertyValue) {
        try {
            method.invoke(object, propertyValue);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public static boolean isNoArgsHasReturn(Method method) {
        return method.getParameterCount() == 0 && method.getReturnType() != Void.class;
    }

    public static String formatGetter(String methodName) {
        return Introspector.decapitalize(methodName.replaceFirst("^(get|is)(?=[A-Z])", ""));
    }

    public static String concat(String path, String name) {
        return path + '.' + name;
    }

    static String concatSafely(@Nullable String path, String name) {
        return path == null ? name : BeanUtils.concat(path, name);
    }

    public static String concat(int index) {
        return '[' + String.valueOf(index) + ']';
    }

    public static String concat(String path, int index) {
        return path + BeanUtils.concat(index);
    }

    public static String concatSafely(@Nullable String path, int index) {
        return path == null ? BeanUtils.concat(index) : BeanUtils.concat(path, index);
    }

    static List<String> getFieldNames(Class<?> clazz) {
        return Arrays.stream(clazz.getDeclaredFields()).map(Field::getName).collect(Collectors.toList());
    }
}

