/*
 * Decompiled with CFR 0.152.
 */
package com.github.peacetrue.bean;

import com.github.peacetrue.bean.BeanProperty;
import com.github.peacetrue.bean.BeanTraverser;
import com.github.peacetrue.bean.BeanUtils;
import com.github.peacetrue.bean.CoreBeanVisitor;
import com.github.peacetrue.bean.DefaultInstanceFactory;
import com.github.peacetrue.bean.InstanceFactory;
import com.github.peacetrue.bean.StandardBeanTraverser;
import com.github.peacetrue.util.stream.StreamUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;

public class CloneBeanVisitor
extends CoreBeanVisitor<Object> {
    public static final CloneBeanVisitor DEFAULT = CloneBeanVisitor.builder().build();
    private static final ThreadLocal<Map<Object, Class<?>>> DECLARE_CLASSES = new ThreadLocal();
    private BeanTraverser<BeanProperty> beanTraverser;
    private InstanceFactory instanceFactory;

    private static Class<?> getDeclareClass(Object object) {
        return DECLARE_CLASSES.get().getOrDefault(object, object.getClass());
    }

    @Override
    public Object visitRoot(Object object) {
        try {
            DECLARE_CLASSES.set(new HashMap());
            Object t = super.visitRoot(object);
            return t;
        }
        finally {
            DECLARE_CLASSES.remove();
        }
    }

    @Override
    @Nullable
    public Object visitLeaf(@Nullable String path, @Nullable Object object) {
        return object;
    }

    @Override
    public Object visitCollection(@Nullable String path, Iterable<?> iterable) {
        if (Collection.class.isAssignableFrom(iterable.getClass())) {
            int[] i = new int[]{0};
            return StreamUtils.iteratorAsStream(iterable.iterator()).map(item -> {
                int n = i[0];
                nArray[0] = n + 1;
                return this.visitAny(BeanUtils.concatSafely(path, n), item);
            }).collect(Collectors.toCollection(() -> this.instanceFactory.createInstance(Collection.class, (Collection)iterable)));
        }
        throw new IllegalStateException("the iterable source object must be Collection to add element");
    }

    @Override
    public Object visitCollection(@Nullable String path, Object[] array) {
        Object[] clone = (Object[])array.clone();
        for (int i = 0; i < clone.length; ++i) {
            clone[i] = this.visitAny(BeanUtils.concatSafely(path, i), clone[i]);
        }
        return clone;
    }

    @Override
    public Object visitParent(@Nullable String path, Object object) {
        Map<Object, Class<?>> map = DECLARE_CLASSES.get();
        Class<?> declareClass = map.getOrDefault(object, object.getClass());
        Object instance = this.instanceFactory.createInstance(declareClass, object);
        this.beanTraverser.buildPropertyStream(path, instance).forEach(beanProperty -> {
            Object propertyValue = beanProperty.getValue(object);
            if (propertyValue == null) {
                return;
            }
            map.put(propertyValue, beanProperty.getType());
            beanProperty.setValue(instance, this.visitAny(BeanUtils.concatSafely(path, beanProperty.getName()), propertyValue));
        });
        return instance;
    }

    @Override
    public Object visitParent(@Nullable String path, Map<?, ?> object) {
        Map instance = this.instanceFactory.createInstance(Map.class, object);
        instance.putAll(object);
        return instance;
    }

    @Generated
    private static BeanTraverser<BeanProperty> $default$beanTraverser() {
        return StandardBeanTraverser.NONNULL_WRITE_METHOD;
    }

    @Generated
    private static InstanceFactory $default$instanceFactory() {
        return DefaultInstanceFactory.DEFAULT;
    }

    @Generated
    protected CloneBeanVisitor(CloneBeanVisitorBuilder<?, ?> b) {
        super(b);
        this.beanTraverser = ((CloneBeanVisitorBuilder)b).beanTraverser$set ? ((CloneBeanVisitorBuilder)b).beanTraverser : CloneBeanVisitor.$default$beanTraverser();
        this.instanceFactory = ((CloneBeanVisitorBuilder)b).instanceFactory$set ? ((CloneBeanVisitorBuilder)b).instanceFactory : CloneBeanVisitor.$default$instanceFactory();
    }

    @Generated
    public static CloneBeanVisitorBuilder<?, ?> builder() {
        return new CloneBeanVisitorBuilderImpl();
    }

    @Generated
    private static final class CloneBeanVisitorBuilderImpl
    extends CloneBeanVisitorBuilder<CloneBeanVisitor, CloneBeanVisitorBuilderImpl> {
        @Generated
        private CloneBeanVisitorBuilderImpl() {
        }

        @Override
        @Generated
        protected CloneBeanVisitorBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public CloneBeanVisitor build() {
            return new CloneBeanVisitor(this);
        }
    }

    @Generated
    public static abstract class CloneBeanVisitorBuilder<C extends CloneBeanVisitor, B extends CloneBeanVisitorBuilder<C, B>>
    extends CoreBeanVisitor.CoreBeanVisitorBuilder<Object, C, B> {
        @Generated
        private boolean beanTraverser$set;
        @Generated
        private BeanTraverser<BeanProperty> beanTraverser;
        @Generated
        private boolean instanceFactory$set;
        @Generated
        private InstanceFactory instanceFactory;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B beanTraverser(BeanTraverser<BeanProperty> beanTraverser) {
            this.beanTraverser = beanTraverser;
            this.beanTraverser$set = true;
            return (B)this.self();
        }

        @Generated
        public B instanceFactory(InstanceFactory instanceFactory) {
            this.instanceFactory = instanceFactory;
            this.instanceFactory$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "CloneBeanVisitor.CloneBeanVisitorBuilder(super=" + super.toString() + ", beanTraverser=" + this.beanTraverser + ", instanceFactory=" + this.instanceFactory + ")";
        }
    }
}

