/*
 * Decompiled with CFR 0.152.
 */
package com.github.peacetrue.bean;

import com.github.peacetrue.bean.BeanUtils;
import com.github.peacetrue.bean.BeanVisitor;
import java.util.Arrays;
import java.util.Map;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import lombok.Generated;

public abstract class CoreBeanVisitor<T>
implements BeanVisitor<T> {
    private BiPredicate<String, Class<?>> isLeafType;

    @Override
    public T visitAny(@Nullable String path, @Nullable Object object) {
        if (object == null || this.isLeaf(path, object)) {
            return this.visitLeaf(path, object);
        }
        Class<?> clazz = object.getClass();
        if (Iterable.class.isAssignableFrom(clazz)) {
            return this.visitCollection(path, (Iterable)object);
        }
        if (clazz.isArray()) {
            return this.visitCollection(path, (Object[])object);
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return this.visitParent(path, (Map)object);
        }
        return this.visitParent(path, object);
    }

    protected boolean isLeaf(@Nullable String path, Object object) {
        return this.isLeafType.test(path, object.getClass());
    }

    public static boolean isSimpleValueType(@Nullable String path, Class<?> clazz) {
        return BeanUtils.isSimpleValueType(clazz);
    }

    public static BiPredicate<String, Class<?>> in(Class<?> ... classes) {
        return (path, clazz) -> Arrays.stream(classes).anyMatch(item -> clazz == item);
    }

    public static BiPredicate<String, Class<?>> isSubclassOf(Class<?> ... superclasses) {
        return (path, clazz) -> BeanUtils.isSubclassOf(clazz, superclasses);
    }

    @Generated
    private static <T> BiPredicate<String, Class<?>> $default$isLeafType() {
        return CoreBeanVisitor::isSimpleValueType;
    }

    @Generated
    protected CoreBeanVisitor(CoreBeanVisitorBuilder<T, ?, ?> b) {
        this.isLeafType = ((CoreBeanVisitorBuilder)b).isLeafType$set ? ((CoreBeanVisitorBuilder)b).isLeafType : CoreBeanVisitor.$default$isLeafType();
    }

    @Generated
    public BiPredicate<String, Class<?>> getIsLeafType() {
        return this.isLeafType;
    }

    @Generated
    public static abstract class CoreBeanVisitorBuilder<T, C extends CoreBeanVisitor<T>, B extends CoreBeanVisitorBuilder<T, C, B>> {
        @Generated
        private boolean isLeafType$set;
        @Generated
        private BiPredicate<String, Class<?>> isLeafType;

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public B isLeafType(BiPredicate<String, Class<?>> isLeafType) {
            this.isLeafType = isLeafType;
            this.isLeafType$set = true;
            return this.self();
        }

        @Generated
        public String toString() {
            return "CoreBeanVisitor.CoreBeanVisitorBuilder(isLeafType=" + this.isLeafType + ")";
        }
    }
}

