/*
 * Decompiled with CFR 0.152.
 */
package com.github.peacetrue.bean;

import com.github.peacetrue.bean.BeanTraverser;
import com.github.peacetrue.bean.BeanUtils;
import com.github.peacetrue.bean.ReadMethodBeanProperty;
import com.github.peacetrue.bean.ReadonlyBeanProperty;
import java.beans.BeanInfo;
import java.beans.MethodDescriptor;
import java.lang.reflect.Method;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import lombok.Generated;

public class CustomReadonlyBeanTraverser
implements BeanTraverser<ReadonlyBeanProperty> {
    public static final CustomReadonlyBeanTraverser DEFAULT = new CustomReadonlyBeanTraverser(method -> true);
    private final Predicate<Method> isValidMethod;

    @Override
    public Stream<ReadonlyBeanProperty> buildPropertyStream(@Nullable String path, Object object) {
        Class<?> type = object.getClass();
        BeanInfo beanInfo = BeanUtils.getBeanInfo(type);
        return Stream.of(beanInfo.getMethodDescriptors()).map(MethodDescriptor::getMethod).filter(BeanUtils::isNoArgsHasReturn).filter(this.isValidMethod).map(ReadMethodBeanProperty::new);
    }

    public static Predicate<Method> exclude(String ... methodNames) {
        return method -> {
            String name = method.getName();
            return Stream.of(methodNames).noneMatch(item -> item.equals(name));
        };
    }

    @Generated
    public CustomReadonlyBeanTraverser(Predicate<Method> isValidMethod) {
        this.isValidMethod = isValidMethod;
    }
}

