/*
 * Decompiled with CFR 0.152.
 */
package com.github.peacetrue.bean;

import com.github.peacetrue.bean.BeanProperty;
import com.github.peacetrue.bean.BeanTraverser;
import com.github.peacetrue.bean.BeanUtils;
import com.github.peacetrue.bean.DescriptorBeanProperty;
import java.beans.BeanInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import lombok.Generated;

public class StandardBeanTraverser
implements BeanTraverser<BeanProperty> {
    public static final StandardBeanTraverser NONNULL_WRITE_METHOD = new StandardBeanTraverser(false);
    public static final StandardBeanTraverser NULLABLE_WRITE_METHOD = new StandardBeanTraverser(true);
    private final boolean nullableWriteMethod;
    private final Map<Class<?>, List<BeanProperty>> beanProperties = new HashMap();

    @Override
    public Stream<BeanProperty> buildPropertyStream(@Nullable String path, Object object) {
        return this.beanProperties.computeIfAbsent(object.getClass(), clazz -> {
            BeanInfo beanInfo = BeanUtils.getBeanInfo(object.getClass());
            return Stream.of(beanInfo.getPropertyDescriptors()).filter(descriptor -> descriptor.getReadMethod() != null && (this.nullableWriteMethod || descriptor.getWriteMethod() != null)).map(DescriptorBeanProperty::new).collect(Collectors.toList());
        }).stream();
    }

    @Generated
    public StandardBeanTraverser(boolean nullableWriteMethod) {
        this.nullableWriteMethod = nullableWriteMethod;
    }
}

