/*
 * Decompiled with CFR 0.152.
 */
package com.github.peacetrue.beanmap;

import com.github.peacetrue.beanmap.FlatPropertyVisitor;
import com.github.peacetrue.beanmap.PropertyVisitor;
import com.github.peacetrue.beanmap.SupplierPropertyVisitor;
import com.github.peacetrue.util.RegexUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import javax.annotation.Nullable;

public class BeanMapUtils {
    public static final char BEAN_SEPARATOR = '.';
    public static final char LIST_START_SEPARATOR = '[';
    public static final char LIST_END_SEPARATOR = ']';
    public static final Pattern LIST_IDENTIFIER_PATTERN = Pattern.compile("(\\w+)\\[( *\\d+ *)]");
    private static int listMaxSize = 100;

    private BeanMapUtils() {
    }

    public static void setListMaxSize(int listMaxSize) {
        BeanMapUtils.listMaxSize = listMaxSize;
    }

    public static <T> T walkTree(Map<String, Object> tiered, SupplierPropertyVisitor<T> visitor) {
        visitor.visitBean(null, tiered);
        return visitor.get();
    }

    public static void walkTree(Map<String, Object> tiered, PropertyVisitor visitor) {
        visitor.visitBean(null, tiered);
    }

    static boolean isBean(@Nullable Object propertyValue) {
        return propertyValue instanceof Map;
    }

    static boolean isCollection(@Nullable Object propertyValue) {
        return propertyValue instanceof Collection;
    }

    public static Map<String, Object> flatten(Map<String, Object> tiered) {
        return (Map)BeanMapUtils.walkTree(tiered, new FlatPropertyVisitor(tiered.size()));
    }

    public static Map<String, Object> tier(Map<String, ?> flat) {
        LinkedHashMap<String, Object> tiered = new LinkedHashMap<String, Object>(flat.size());
        BeanMapUtils.tier(flat, new HashSet<String>(), tiered);
        return tiered;
    }

    private static <T> void tier(Map<String, T> flat, Set<String> handled, Map<String, Object> tiered) {
        for (Map.Entry<String, T> property : flat.entrySet()) {
            Object subTiered;
            String propertyPath = property.getKey();
            if (handled.contains(propertyPath)) continue;
            int beanSeparateIndex = propertyPath.indexOf(46);
            if (beanSeparateIndex == -1) {
                String[] nameIndex = RegexUtils.extractValues(LIST_IDENTIFIER_PATTERN, propertyPath);
                if (nameIndex.length == 0) {
                    tiered.put(propertyPath, property.getValue());
                    continue;
                }
                List subTiered2 = (List)tiered.computeIfAbsent(nameIndex[0], item -> new LinkedList());
                BeanMapUtils.setListElement(subTiered2, Integer.parseInt(nameIndex[1].trim()), property.getValue());
                continue;
            }
            String headPropertyPath = propertyPath.substring(0, beanSeparateIndex);
            String headPrefix = headPropertyPath + '.';
            Map<String, T> subFlat = BeanMapUtils.filterByKeyPrefix(flat, headPrefix);
            handled.addAll(subFlat.keySet());
            subFlat = BeanMapUtils.subByKeyPrefix(subFlat, headPrefix);
            String[] nameIndex = RegexUtils.extractValues(LIST_IDENTIFIER_PATTERN, headPropertyPath);
            if (nameIndex.length == 0) {
                subTiered = (Map)tiered.computeIfAbsent(headPropertyPath, item -> new LinkedHashMap());
                BeanMapUtils.tier(subFlat, new HashSet<String>(), (Map<String, Object>)subTiered);
                continue;
            }
            subTiered = (List)tiered.computeIfAbsent(nameIndex[0], item -> new LinkedList());
            Map element = BeanMapUtils.setListElement(subTiered, Integer.parseInt(nameIndex[1].trim()), new LinkedHashMap());
            BeanMapUtils.tier(subFlat, new HashSet<String>(), element);
        }
    }

    static <T> T setListElement(List<T> elements, int index, T element) {
        if (index >= listMaxSize) {
            throw new IllegalArgumentException("Index " + index + " exceeds upper limit: " + listMaxSize);
        }
        if (index >= elements.size()) {
            IntStream.rangeClosed(elements.size(), index).forEach(i -> elements.add(null));
        }
        elements.set(index, element);
        return element;
    }

    private static <T> Map<String, T> filterByKeyPrefix(Map<String, T> map, String keyPrefix) {
        return map.entrySet().stream().filter(item -> ((String)item.getKey()).startsWith(keyPrefix)).collect(LinkedHashMap::new, (c, e) -> c.put(e.getKey(), e.getValue()), HashMap::putAll);
    }

    private static <T> Map<String, T> subByKeyPrefix(Map<String, T> subFlat, String keyPrefix) {
        int length = keyPrefix.length();
        return subFlat.entrySet().stream().collect(LinkedHashMap::new, (c, e) -> c.put(((String)e.getKey()).substring(length), e.getValue()), HashMap::putAll);
    }

    static String concat(String path, String name) {
        return path + '.' + name;
    }

    static String concatSafely(@Nullable String path, String name) {
        return path == null ? name : BeanMapUtils.concat(path, name);
    }

    static String concat(int index) {
        return '[' + String.valueOf(index) + ']';
    }

    static String concat(String path, int index) {
        return path + BeanMapUtils.concat(index);
    }

    static String concatSafely(@Nullable String path, int index) {
        return path == null ? BeanMapUtils.concat(index) : BeanMapUtils.concat(path, index);
    }
}

