/*
 * Decompiled with CFR 0.152.
 */
package com.github.peacetrue.beanmap;

import com.github.peacetrue.beanmap.BeanMapUtils;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;

public interface PropertyVisitor {
    default public void visit(@Nullable String path, Object value) {
        if (BeanMapUtils.isBean(value)) {
            this.visitBean(path, (Map)value);
        } else if (BeanMapUtils.isCollection(value)) {
            this.visitCollection(path, (Collection)value);
        } else {
            this.visitPrimitive(path, value);
        }
    }

    default public void visitBean(@Nullable String path, Map<String, Object> bean) {
        for (Map.Entry<String, Object> entry : bean.entrySet()) {
            this.visitBeanProperty(path, entry.getKey(), entry.getValue());
        }
    }

    default public void visitBeanProperty(@Nullable String path, String name, Object value) {
        this.visit(BeanMapUtils.concatSafely(path, name), value);
    }

    default public void visitCollection(@Nullable String path, Collection<?> value) {
        int i = 0;
        for (Object element : value) {
            this.visitCollectionElement(path, i++, element);
        }
    }

    default public void visitCollectionElement(@Nullable String path, int index, Object value) {
        this.visit(BeanMapUtils.concatSafely(path, index), value);
    }

    public void visitPrimitive(@Nullable String var1, @Nullable Object var2);
}

