/*
 * Decompiled with CFR 0.152.
 */
package com.github.peacetrue.lang;

import com.github.peacetrue.lang.CommandUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessBuilderUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessBuilderUtils.class);

    private ProcessBuilderUtils() {
    }

    public static Process exec(String ... commands) throws IOException {
        return new ProcessBuilder(new String[0]).inheritIO().command(commands).start();
    }

    public static Process lsofCurrent(String ... commands) throws IOException {
        return ProcessBuilderUtils.exec(CommandUtils.sh(String.format("lsof -nP -p %s %s", ProcessBuilderUtils.getPid(), String.join((CharSequence)" ", commands))));
    }

    static int getPid() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        return Integer.parseInt(name.split("@")[0]);
    }

    public static void logAsync(InputStream inputStream) {
        new Thread(() -> ProcessBuilderUtils.log(inputStream)).start();
    }

    public static void log(InputStream inputStream) {
        LinkedList<Byte> byteList = new LinkedList<Byte>();
        try {
            while (true) {
                byte bytes;
                if ((bytes = (byte)inputStream.read()) == -1) {
                    ProcessBuilderUtils.log(byteList);
                    break;
                }
                if (bytes == 10) {
                    ProcessBuilderUtils.log(byteList);
                    byteList.clear();
                    continue;
                }
                byteList.add(bytes);
            }
        }
        catch (IOException e) {
            log.error("log inputStream error", (Throwable)e);
        }
    }

    private static void log(List<Byte> bytes) {
        if (!bytes.isEmpty()) {
            log.debug("{}", (Object)new String(ProcessBuilderUtils.toBytes(bytes), StandardCharsets.UTF_8));
        }
    }

    private static byte[] toBytes(List<Byte> byteList) {
        int i = 0;
        byte[] byteArray = new byte[byteList.size()];
        for (Byte bytes : byteList) {
            byteArray[i++] = bytes;
        }
        return byteArray;
    }
}

