/*
 * Decompiled with CFR 0.152.
 */
package com.github.peacetrue.net;

import com.github.peacetrue.beanmap.BeanMapUtils;
import com.github.peacetrue.beanmap.FlatPropertyVisitor;
import com.github.peacetrue.lang.ObjectUtils;
import com.github.peacetrue.net.URLCodecUtils;
import com.github.peacetrue.util.ArrayUtils;
import com.github.peacetrue.util.stream.StreamUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class URLQueryUtils {
    private URLQueryUtils() {
    }

    public static Map<String, List<String>> parseQuery(String query) {
        Map queryParams = Stream.of(query.split("&")).filter(item -> !item.trim().isEmpty()).map(item -> item.split("=", 2)).map(item -> ArrayUtils.replace(item, URLCodecUtils::decode)).collect(Collectors.groupingBy(item -> item[0], LinkedHashMap::new, Collectors.mapping(item -> ((String[])item).length == 1 ? null : item[1], Collectors.toList())));
        queryParams.entrySet().stream().filter(item -> ((List)item.getValue()).get(0) == null).forEach(item -> {
            List cfr_ignored_0 = item.setValue(null);
        });
        return queryParams;
    }

    public static String toQuery(Map<String, ? extends Collection<?>> params) {
        return params.entrySet().stream().filter(item -> Objects.nonNull(item.getKey())).flatMap(item -> {
            Collection collection = (Collection)item.getValue();
            return collection == null || URLQueryUtils.allNull(collection) ? Stream.of(URLCodecUtils.encode((String)item.getKey())) : collection.stream().map(value -> URLQueryUtils.encode((String)item.getKey(), value));
        }).collect(Collectors.joining("&"));
    }

    private static String encode(String key, Object value) {
        String encodedKey = URLCodecUtils.encode(key);
        return encodedKey + "=" + URLCodecUtils.encode(Objects.toString(value, ""));
    }

    public static Map<String, List<String>> fromBeanMap(Map<String, ?> flat) {
        return flat.entrySet().stream().collect(LinkedHashMap::new, (c, e) -> c.put(e.getKey(), URLQueryUtils.toList(e.getValue())), HashMap::putAll);
    }

    @Nullable
    private static List<String> toList(@Nullable Object value) {
        return ObjectUtils.invokeSafely(value, temp -> StreamUtils.toStream(temp, Stream::of).map(item -> Objects.toString(item, null)).collect(Collectors.toList()));
    }

    public static Map<String, Object> toBeanMap(Map<String, ? extends List<?>> flat) {
        return flat.entrySet().stream().collect(LinkedHashMap::new, (c, e) -> c.put(e.getKey(), URLQueryUtils.unwrapSingleListValue((List)e.getValue())), HashMap::putAll);
    }

    @Nullable
    private static Object unwrapSingleListValue(@Nullable List<?> value) {
        if (value == null || URLQueryUtils.allNull(value)) {
            return null;
        }
        return value.size() > 1 ? value : value.get(0);
    }

    private static boolean allNull(Collection<?> collection) {
        return collection.stream().allMatch(Objects::isNull);
    }

    public static Map<String, List<String>> flatten(Map<String, Object> tiered) {
        return BeanMapUtils.walkTree(tiered, new FlatPropertyVisitor<List<String>>(tiered.size()){

            @Override
            @Nullable
            protected List<String> handleValue(@Nullable Object value) {
                return URLQueryUtils.toList(value);
            }
        });
    }
}

