/*
 * Decompiled with CFR 0.152.
 */
package com.github.peacetrue.range;

import com.github.peacetrue.range.Range;
import lombok.Generated;

public class ComparableRange<T extends Comparable<? super T>>
extends Range<T> {
    public ComparableRange(T bound) {
        super(bound);
    }

    public ComparableRange(T lowerBound, T upperBound) {
        super(lowerBound, upperBound);
    }

    public ComparableRange(T lowerBound, T upperBound, Boolean lowerInclusive, Boolean upperInclusive) {
        super(lowerBound, upperBound, lowerInclusive, upperInclusive);
    }

    public ComparableRange(Range<T> range) {
        super(range);
    }

    private static <T extends Comparable<? super T>> boolean compareTo(T value, T bound, boolean isLower, boolean isInclusive) {
        if (bound == null) {
            return true;
        }
        int compareTo = value.compareTo(bound);
        if (isLower) {
            return isInclusive ? compareTo >= 0 : compareTo > 0;
        }
        return isInclusive ? compareTo <= 0 : compareTo < 0;
    }

    public boolean contains(T value) {
        return ComparableRange.compareTo(value, (Comparable)this.getLowerBound(), true, ComparableRange.isLowerInclusive(this)) && ComparableRange.compareTo(value, (Comparable)this.getUpperBound(), false, ComparableRange.isUpperInclusive(this));
    }

    @Generated
    public ComparableRange() {
    }
}

