/*
 * Decompiled with CFR 0.152.
 */
package com.github.peacetrue.range;

import com.github.peacetrue.lang.ObjectUtils;
import com.github.peacetrue.range.ComparableRange;
import com.github.peacetrue.range.LocalDateTimeRange;
import com.github.peacetrue.range.Range;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalTime;
import lombok.Generated;

public class LocalDateRange
extends ComparableRange<LocalDate>
implements Serializable {
    public static final LocalDateRange DEFAULT = new LocalDateRange();
    private static final long serialVersionUID = 0L;

    public LocalDateRange(LocalDate bound) {
        super(bound);
    }

    public LocalDateRange(LocalDate lowerBound, LocalDate upperBound) {
        super(lowerBound, upperBound);
    }

    public LocalDateRange(LocalDate lowerBound, LocalDate upperBound, Boolean lowerInclusive, Boolean upperInclusive) {
        super(lowerBound, upperBound, lowerInclusive, upperInclusive);
    }

    public LocalDateRange(Range<LocalDate> range) {
        super(range);
    }

    public LocalDateTimeRange toLocalDateTimeRange() {
        LocalDateTimeRange localDateTimeRange = new LocalDateTimeRange();
        localDateTimeRange.setLowerInclusive(this.getLowerInclusive());
        localDateTimeRange.setUpperInclusive(this.getUpperInclusive());
        ObjectUtils.acceptSafely(this.getLowerBound(), bound -> localDateTimeRange.setLowerBound(bound.atTime(LocalTime.MIN)));
        ObjectUtils.acceptSafely(this.getUpperBound(), bound -> localDateTimeRange.setUpperBound(bound.atTime(LocalTime.MAX)));
        return localDateTimeRange;
    }

    @Generated
    public LocalDateRange() {
    }
}

