/*
 * Decompiled with CFR 0.152.
 */
package com.github.peacetrue.range;

import com.github.peacetrue.lang.ObjectUtils;
import com.github.peacetrue.range.ComparableRange;
import com.github.peacetrue.range.LocalDateTimeRange;
import com.github.peacetrue.range.Range;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import lombok.Generated;

public class LongRange
extends ComparableRange<Long>
implements Serializable {
    public static final LongRange DEFAULT = new LongRange();
    private static final long serialVersionUID = 0L;

    public LongRange(Long bound) {
        super(bound);
    }

    public LongRange(Long lowerBound, Long upperBound) {
        super(lowerBound, upperBound);
    }

    public LongRange(Long lowerBound, Long upperBound, Boolean lowerInclusive, Boolean upperInclusive) {
        super(lowerBound, upperBound, lowerInclusive, upperInclusive);
    }

    public LongRange(Range<Long> range) {
        super(range);
    }

    public static void increase(LongRange range, long increment) {
        ObjectUtils.acceptSafely(range.getLowerBound(), value -> range.setLowerBound(value + increment));
        ObjectUtils.acceptSafely(range.getUpperBound(), value -> range.setUpperBound(value + increment));
    }

    public static Long getOffset(Range<Long> range) {
        return range.getUpperBound() - range.getLowerBound();
    }

    private static LocalDateTime toLocalDateTime(Long bound, ZoneId zoneId) {
        return Instant.ofEpochMilli(bound).atZone(zoneId).toLocalDateTime();
    }

    public LongRange increase(long increment) {
        LongRange range = new LongRange(this);
        LongRange.increase(range, increment);
        return range;
    }

    public LocalDateTimeRange toLocalDateTimeRange() {
        return this.toLocalDateTimeRange(ZoneId.systemDefault());
    }

    public LocalDateTimeRange toLocalDateTimeRange(ZoneId zoneId) {
        LocalDateTimeRange localDateTimeRange = new LocalDateTimeRange();
        localDateTimeRange.setLowerInclusive(this.getLowerInclusive());
        localDateTimeRange.setUpperInclusive(this.getUpperInclusive());
        ObjectUtils.acceptSafely(this.getLowerBound(), bound -> localDateTimeRange.setLowerBound(LongRange.toLocalDateTime(bound, zoneId)));
        ObjectUtils.acceptSafely(this.getUpperBound(), bound -> localDateTimeRange.setUpperBound(LongRange.toLocalDateTime(bound, zoneId)));
        return localDateTimeRange;
    }

    @Generated
    public LongRange() {
    }
}

