/*
 * Decompiled with CFR 0.152.
 */
package com.github.peacetrue.range;

import java.util.Objects;
import lombok.Generated;

public class Range<T> {
    private T lowerBound;
    private T upperBound;
    private Boolean lowerInclusive;
    private Boolean upperInclusive;

    public Range() {
    }

    public Range(T bound) {
        this(bound, bound);
    }

    public Range(T lowerBound, T upperBound) {
        this(lowerBound, upperBound, true, true);
    }

    public Range(T lowerBound, T upperBound, Boolean lowerInclusive, Boolean upperInclusive) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.lowerInclusive = lowerInclusive;
        this.upperInclusive = upperInclusive;
    }

    public Range(Range<T> range) {
        this(range.lowerBound, range.upperBound, range.lowerInclusive, range.upperInclusive);
    }

    public static boolean isEmpty(Range<?> range) {
        return range.lowerBound == null && range.upperBound == null;
    }

    public static boolean isFull(Range<?> range) {
        return range.lowerBound != null && range.upperBound != null;
    }

    public static boolean isLowerInclusive(Range<?> range) {
        return !Boolean.FALSE.equals(range.lowerInclusive);
    }

    public static boolean isUpperInclusive(Range<?> range) {
        return !Boolean.FALSE.equals(range.upperInclusive);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Range range = (Range)o;
        return Objects.equals(this.lowerBound, range.lowerBound) && Objects.equals(this.upperBound, range.upperBound) && Objects.equals(this.lowerInclusive, range.lowerInclusive) && Objects.equals(this.upperInclusive, range.upperInclusive);
    }

    public int hashCode() {
        return Objects.hash(this.lowerBound, this.upperBound, this.lowerInclusive, this.upperInclusive);
    }

    public String toString() {
        return String.format("%s%s, %s%s", Character.valueOf(Range.isLowerInclusive(this) ? (char)'[' : '('), Objects.toString(this.lowerBound, "-\u221e"), Objects.toString(this.upperBound, "+\u221e"), Character.valueOf(Range.isUpperInclusive(this) ? (char)']' : ')'));
    }

    @Generated
    public T getLowerBound() {
        return this.lowerBound;
    }

    @Generated
    public T getUpperBound() {
        return this.upperBound;
    }

    @Generated
    public Boolean getLowerInclusive() {
        return this.lowerInclusive;
    }

    @Generated
    public Boolean getUpperInclusive() {
        return this.upperInclusive;
    }

    @Generated
    public void setLowerBound(T lowerBound) {
        this.lowerBound = lowerBound;
    }

    @Generated
    public void setUpperBound(T upperBound) {
        this.upperBound = upperBound;
    }

    @Generated
    public void setLowerInclusive(Boolean lowerInclusive) {
        this.lowerInclusive = lowerInclusive;
    }

    @Generated
    public void setUpperInclusive(Boolean upperInclusive) {
        this.upperInclusive = upperInclusive;
    }
}

