/*
 * Decompiled with CFR 0.152.
 */
package com.github.peacetrue.util.stream;

import com.github.peacetrue.lang.ObjectUtils;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public class StreamUtils {
    private StreamUtils() {
    }

    public static <T> Stream<T> toStreamSafely(@Nullable Object data) {
        return StreamUtils.toStreamSafely(data, Stream.empty(), temp -> Stream.of(temp));
    }

    public static <T> Stream<T> toStreamSafely(@Nullable Object data, Stream<T> defaults, Function<Object, Stream<T>> converter) {
        return ObjectUtils.invokeSafely(data, defaults, temp -> StreamUtils.toStream(temp, converter));
    }

    public static <T> Stream<T> toStreamSafelyLazily(@Nullable Object data, Supplier<Stream<T>> defaults, Function<Object, Stream<T>> converter) {
        return ObjectUtils.invokeSafelyLazily(data, defaults, temp -> StreamUtils.toStream(temp, converter));
    }

    @Nullable
    public static <T> Stream<T> toStreamNullable(Object object) {
        return StreamUtils.toStream(object, temp -> null);
    }

    public static <T> Stream<T> toStream(Object streamable) throws UnsupportedOperationException {
        return StreamUtils.toStream(streamable, temp -> {
            String message = "Parameter streamable must be one of Stream, Object[], Collection, Iterator, Iterable, Type " + streamable.getClass().getName() + " is not supported";
            throw new UnsupportedOperationException(message);
        });
    }

    public static <T> Stream<T> toStream(Object data, Function<Object, Stream<T>> converter) {
        Objects.requireNonNull(data, "data must not be null");
        if (data instanceof Iterable) {
            return StreamUtils.iteratorAsStream(((Iterable)data).iterator());
        }
        if (data instanceof Object[]) {
            return Stream.of((Object[])data);
        }
        if (data instanceof Enumeration) {
            return StreamUtils.enumerationAsStream((Enumeration)data);
        }
        if (data instanceof Iterator) {
            return StreamUtils.iteratorAsStream((Iterator)data);
        }
        if (data instanceof Stream) {
            return (Stream)data;
        }
        return converter.apply(data);
    }

    public static <T> Stream<T> iteratorAsStream(Iterator<T> iterator) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false);
    }

    public static <T> Stream<T> enumerationAsStream(Enumeration<T> enumeration) {
        return StreamUtils.iteratorAsStream(StreamUtils.enumerationAsIterator(enumeration));
    }

    public static <T> Iterator<T> enumerationAsIterator(final Enumeration<T> enumeration) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            @Override
            public T next() {
                return enumeration.nextElement();
            }
        };
    }

    public static <T, E, R> R invoke(T data, Function<Stream<E>, R> streamInvoker, Function<T, R> dataInvoker) {
        return (R)ObjectUtils.invokeSafelyLazily(StreamUtils.toStreamNullable(data), () -> dataInvoker.apply(data), stream -> streamInvoker.apply((Stream)stream));
    }
}

