/*
 * Decompiled with CFR 0.152.
 */
package com.github.peacetrue.test;

import java.io.File;
import java.util.Arrays;
import java.util.Objects;

public class SourcePathUtils {
    public static final String PATH_SRC = File.separatorChar + "src";
    public static final String PATH_MAIN = File.separatorChar + "main";
    public static final String PATH_TEST = File.separatorChar + "test";
    public static final String PATH_JAVA = File.separatorChar + "java";
    public static final String PATH_RESOURCES = File.separatorChar + "resources";
    public static final String PATH_SRC_MAIN = PATH_SRC + PATH_MAIN;
    public static final String PATH_SRC_MAIN_JAVA = PATH_SRC_MAIN + PATH_JAVA;
    public static final String PATH_SRC_MAIN_RESOURCES = PATH_SRC_MAIN + PATH_RESOURCES;
    public static final String PATH_SRC_TEST = PATH_SRC + PATH_TEST;
    public static final String PATH_SRC_TEST_JAVA = PATH_SRC_TEST + PATH_JAVA;
    public static final String PATH_SRC_TEST_RESOURCES = PATH_SRC_TEST + PATH_RESOURCES;

    private SourcePathUtils() {
    }

    public static String classToPath(Class<?> clazz, boolean isAbsolute, boolean isPackage) {
        String name = isPackage ? clazz.getPackage().getName() : clazz.getName();
        String path = name.replace('.', File.separatorChar);
        return isAbsolute ? File.separatorChar + path : path;
    }

    public static String getProjectAbsolutePath() {
        return Objects.toString(System.getProperty("user.dir"), System.getenv("PWD"));
    }

    public static String getCustomAbsolutePath(boolean isTest, boolean isResources, String ... paths) {
        StringBuilder builder = new StringBuilder(SourcePathUtils.getProjectAbsolutePath()).append(PATH_SRC).append(isTest ? PATH_TEST : PATH_MAIN).append(isResources ? PATH_RESOURCES : PATH_JAVA);
        Arrays.asList(paths).forEach(builder::append);
        return builder.toString();
    }

    public static String getTestResourceAbsolutePath(String ... paths) {
        return SourcePathUtils.getCustomAbsolutePath(true, true, paths);
    }
}

