/*
 * Decompiled with CFR 0.152.
 */
package com.github.peacetrue.test;

import java.util.LinkedHashMap;
import java.util.Map;

public class ThreadAssertionUtils {
    private ThreadAssertionUtils() {
    }

    public static Map<Thread, AssertionError> catchAssertionErrors() {
        LinkedHashMap<Thread, AssertionError> errors = new LinkedHashMap<Thread, AssertionError>(1);
        Thread.setDefaultUncaughtExceptionHandler((thread, throwable) -> {
            if (throwable instanceof AssertionError) {
                errors.put(thread, (AssertionError)((Object)throwable));
            }
        });
        return errors;
    }

    public static void propagateAssertionError(Map<Thread, AssertionError> errors) {
        if (!errors.isEmpty()) {
            throw errors.values().iterator().next();
        }
    }

    public static void propagateAssertionError(Runnable runnable) {
        Map<Thread, AssertionError> errors = ThreadAssertionUtils.catchAssertionErrors();
        runnable.run();
        ThreadAssertionUtils.propagateAssertionError(errors);
    }
}

