/*
 * Decompiled with CFR 0.152.
 */
package com.github.peeveen.ultimateguitar;

import com.github.peeveen.ultimateguitar.Chord;
import com.github.peeveen.ultimateguitar.Line;
import com.github.peeveen.ultimateguitar.SongResultStorePageData;
import com.github.peeveen.ultimateguitar.TabInfo;
import com.github.peeveen.ultimateguitar.TabView;
import com.github.peeveen.ultimateguitar.TabViewMeta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000fJ\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/github/peeveen/ultimateguitar/Song;", "", "data", "Lcom/github/peeveen/ultimateguitar/SongResultStorePageData;", "<init>", "(Lcom/github/peeveen/ultimateguitar/SongResultStorePageData;)V", "tabInfo", "Lcom/github/peeveen/ultimateguitar/TabInfo;", "getTabInfo", "()Lcom/github/peeveen/ultimateguitar/TabInfo;", "tabView", "Lcom/github/peeveen/ultimateguitar/TabView;", "getTabView", "()Lcom/github/peeveen/ultimateguitar/TabView;", "lines", "", "Lcom/github/peeveen/ultimateguitar/Line;", "toChordPro", "", "toPlainText", "Companion", "ultimateguitar"})
@SourceDebugExtension(value={"SMAP\nSong.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Song.kt\ncom/github/peeveen/ultimateguitar/Song\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,218:1\n1557#2:219\n1628#2,3:220\n1368#2:227\n1454#2,2:228\n774#2:230\n865#2,2:231\n1456#2,3:233\n37#3:223\n36#3,3:224\n37#3:236\n36#3,3:237\n*S KotlinDebug\n*F\n+ 1 Song.kt\ncom/github/peeveen/ultimateguitar/Song\n*L\n73#1:219\n73#1:220,3\n100#1:227\n100#1:228,2\n100#1:230\n100#1:231,2\n100#1:233,3\n83#1:223\n83#1:224,3\n108#1:236\n108#1:237,3\n*E\n"})
public final class Song {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TabInfo tabInfo;
    @NotNull
    private final TabView tabView;
    @NotNull
    private final List<Line> lines;
    @NotNull
    private static final String TAB_MARKER_START = "[tab]";
    @NotNull
    private static final String TAB_MARKER_END = "[/tab]";
    @NotNull
    private static final String CHORD_MARKER_START = "[ch]";
    @NotNull
    private static final String CHORD_MARKER_END = "[/ch]";
    @NotNull
    public static final String CHORD_START = "[";
    @NotNull
    public static final String CHORD_END = "]";

    public Song(@NotNull SongResultStorePageData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.tabInfo = data.getTabInfo();
        this.tabView = data.getTabView();
        this.lines = Song.Companion.parseLines(data.getTabView().getWikiTab().getContent());
    }

    @NotNull
    public final TabInfo getTabInfo() {
        return this.tabInfo;
    }

    @NotNull
    public final TabView getTabView() {
        return this.tabView;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> toChordPro() {
        void $this$mapTo$iv$iv;
        String titleLine = "{title:" + this.tabInfo.getSongName() + '}';
        String artistLine = "{artist:" + this.tabInfo.getArtistName() + '}';
        TabViewMeta tabViewMeta = this.tabView.getMeta();
        String capoLine = (tabViewMeta != null ? Integer.valueOf(tabViewMeta.getCapo()) : null) != null && this.tabView.getMeta().getCapo() > 0 ? "{capo:" + this.tabView.getMeta().getCapo() + '}' : null;
        String keyLine = !StringsKt.isBlank((CharSequence)this.tabInfo.getKey()) ? "{key:" + this.tabInfo.getKey() + '}' : null;
        long rating = RangesKt.coerceAtMost((long)Math.round(this.tabInfo.getRating()), (long)5L);
        String ratingLine = rating > 0L ? "{rating:" + rating + '}' : null;
        String string = this.tabInfo.getCreator();
        String creatorLine = (string != null ? !StringsKt.isBlank((CharSequence)string) : false) && !Intrinsics.areEqual((Object)this.tabInfo.getCreator(), (Object)"Unregistered") ? "{comment:Created by @" + this.tabInfo.getCreator() + '}' : null;
        TabViewMeta tabViewMeta2 = this.tabView.getMeta();
        String tuningLine = (tabViewMeta2 != null ? tabViewMeta2.getTuning() : null) != null && !Intrinsics.areEqual((Object)this.tabView.getMeta().getTuning().getName(), (Object)"Standard") ? "{comment:Tuning = " + this.tabView.getMeta().getTuning().getName() + " (" + this.tabView.getMeta().getTuning().getValue() + ")}" : null;
        Iterable $this$map$iv = this.lines;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Line line = (Line)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toChordPro());
        }
        List songLines = (List)destination$iv$iv;
        SpreadBuilder spreadBuilder = new SpreadBuilder(9);
        spreadBuilder.add((Object)titleLine);
        spreadBuilder.add((Object)artistLine);
        spreadBuilder.add((Object)capoLine);
        spreadBuilder.add((Object)keyLine);
        spreadBuilder.add((Object)ratingLine);
        spreadBuilder.add((Object)creatorLine);
        spreadBuilder.add((Object)tuningLine);
        spreadBuilder.add((Object)"");
        Collection $this$toTypedArray$iv = songLines;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new String[0]));
        return CollectionsKt.listOfNotNull((Object[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> toPlainText() {
        void $this$flatMapTo$iv$iv;
        String artistLine = "by " + this.tabInfo.getArtistName();
        TabViewMeta tabViewMeta = this.tabView.getMeta();
        String capoLine = (tabViewMeta != null ? Integer.valueOf(tabViewMeta.getCapo()) : null) != null && this.tabView.getMeta().getCapo() > 0 ? "CAPO " + this.tabView.getMeta().getCapo() : null;
        String string = this.tabInfo.getCreator();
        String creatorLine = (string != null ? !StringsKt.isBlank((CharSequence)string) : false) && !Intrinsics.areEqual((Object)this.tabInfo.getCreator(), (Object)"Unregistered") ? "Created by @" + this.tabInfo.getCreator() : null;
        TabViewMeta tabViewMeta2 = this.tabView.getMeta();
        String tuningLine = (tabViewMeta2 != null ? tabViewMeta2.getTuning() : null) != null && !Intrinsics.areEqual((Object)this.tabView.getMeta().getTuning().getName(), (Object)"Standard") ? "Tuning = " + this.tabView.getMeta().getTuning().getName() + " (" + this.tabView.getMeta().getTuning().getValue() + ')' : null;
        Iterable $this$flatMap$iv = this.lines;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$filterTo$iv$iv;
            Line it = (Line)element$iv$iv;
            boolean bl = false;
            Iterable $this$filter$iv = it.toPlainText();
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                String line = (String)element$iv$iv2;
                boolean bl2 = false;
                boolean bl3 = !StringsKt.isBlank((CharSequence)line);
                if (!bl3) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List songLines = (List)destination$iv$iv;
        SpreadBuilder spreadBuilder = new SpreadBuilder(7);
        spreadBuilder.add((Object)this.tabInfo.getSongName());
        spreadBuilder.add((Object)artistLine);
        spreadBuilder.add((Object)capoLine);
        spreadBuilder.add((Object)creatorLine);
        spreadBuilder.add((Object)tuningLine);
        spreadBuilder.add((Object)"");
        Collection $this$toTypedArray$iv = songLines;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new String[0]));
        return CollectionsKt.listOfNotNull((Object[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J2\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J*\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\f0\u00172\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J:\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00052\u0018\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001a0\u001eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/github/peeveen/ultimateguitar/Song$Companion;", "", "<init>", "()V", "TAB_MARKER_START", "", "TAB_MARKER_END", "CHORD_MARKER_START", "CHORD_MARKER_END", "CHORD_START", "CHORD_END", "getLines", "", "s", "parseLines", "Lcom/github/peeveen/ultimateguitar/Line;", "content", "lines", "previousLineChords", "Lcom/github/peeveen/ultimateguitar/Chord;", "isTab", "", "extractChords", "Lkotlin/Pair;", "line", "parseMarkers", "", "startMarker", "endMarker", "fn", "Lkotlin/Function2;", "ultimateguitar"})
    @SourceDebugExtension(value={"SMAP\nSong.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Song.kt\ncom/github/peeveen/ultimateguitar/Song$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,218:1\n774#2:219\n865#2,2:220\n37#3:222\n36#3,3:223\n37#3:226\n36#3,3:227\n37#3:230\n36#3,3:231\n37#3:234\n36#3,3:235\n1#4:238\n*S KotlinDebug\n*F\n+ 1 Song.kt\ncom/github/peeveen/ultimateguitar/Song$Companion\n*L\n121#1:219\n121#1:220,2\n147#1:222\n147#1:223,3\n150#1:226\n150#1:227,3\n152#1:230\n152#1:231,3\n157#1:234\n157#1:235,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> getLines(String s) {
            void $this$filterTo$iv$iv;
            char[] cArray = new char[]{'\n', '\r'};
            Iterable $this$filter$iv = StringsKt.split$default((CharSequence)s, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                boolean bl2 = ((CharSequence)it).length() > 0;
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final List<Line> parseLines(String content) {
            List list;
            List $this$parseLines_u24lambda_u242 = list = (List)new ArrayList();
            boolean bl = false;
            Companion.parseMarkers(content, Song.TAB_MARKER_START, Song.TAB_MARKER_END, (Function2<? super String, ? super Boolean, Unit>)((Function2)(arg_0, arg_1) -> Companion.parseLines$lambda$2$lambda$1($this$parseLines_u24lambda_u242, arg_0, arg_1)));
            return list;
        }

        private final List<Line> parseLines(List<String> lines, List<Chord> previousLineChords, boolean isTab) {
            if (lines.isEmpty()) {
                return previousLineChords.isEmpty() ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)new Line("", previousLineChords));
            }
            String nextLine = (String)CollectionsKt.first(lines);
            List remainingLines = CollectionsKt.takeLast(lines, (int)(((Collection)lines).size() - 1));
            Pair<String, List<Chord>> pair = this.extractChords(nextLine, isTab);
            String text = (String)pair.component1();
            List extractedChords = (List)pair.component2();
            if (CollectionsKt.any((Iterable)extractedChords)) {
                List list;
                if (!StringsKt.isBlank((CharSequence)text)) {
                    List list2;
                    if (CollectionsKt.any((Iterable)previousLineChords)) {
                        SpreadBuilder spreadBuilder = new SpreadBuilder(3);
                        spreadBuilder.add((Object)new Line("", previousLineChords));
                        spreadBuilder.add((Object)new Line(text, extractedChords));
                        Collection $this$toTypedArray$iv = this.parseLines(remainingLines, extractedChords, isTab);
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new Line[0]));
                        list2 = CollectionsKt.listOf((Object[])spreadBuilder.toArray((Object[])new Line[spreadBuilder.size()]));
                    } else {
                        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
                        spreadBuilder.add((Object)new Line(text, extractedChords));
                        Collection $this$toTypedArray$iv = this.parseLines(remainingLines, CollectionsKt.emptyList(), isTab);
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new Line[0]));
                        list2 = CollectionsKt.listOf((Object[])spreadBuilder.toArray((Object[])new Line[spreadBuilder.size()]));
                    }
                    return list2;
                }
                if (CollectionsKt.any((Iterable)previousLineChords)) {
                    SpreadBuilder spreadBuilder = new SpreadBuilder(2);
                    spreadBuilder.add((Object)new Line("", previousLineChords));
                    Collection $this$toTypedArray$iv = this.parseLines(remainingLines, extractedChords, isTab);
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new Line[0]));
                    list = CollectionsKt.listOf((Object[])spreadBuilder.toArray((Object[])new Line[spreadBuilder.size()]));
                } else {
                    list = this.parseLines(remainingLines, extractedChords, isTab);
                }
                return list;
            }
            if (!StringsKt.isBlank((CharSequence)text)) {
                SpreadBuilder spreadBuilder = new SpreadBuilder(2);
                spreadBuilder.add((Object)new Line(text, previousLineChords));
                Collection $this$toTypedArray$iv = this.parseLines(remainingLines, CollectionsKt.emptyList(), isTab);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new Line[0]));
                return CollectionsKt.listOf((Object[])spreadBuilder.toArray((Object[])new Line[spreadBuilder.size()]));
            }
            return this.parseLines(remainingLines, CollectionsKt.emptyList(), isTab);
        }

        private final Pair<String, List<Chord>> extractChords(String line, boolean isTab) {
            List chords = new ArrayList();
            Ref.ObjectRef text = new Ref.ObjectRef();
            text.element = "";
            this.parseMarkers(line, Song.CHORD_MARKER_START, Song.CHORD_MARKER_END, (Function2<? super String, ? super Boolean, Unit>)((Function2)(arg_0, arg_1) -> Companion.extractChords$lambda$4(chords, text, isTab, arg_0, arg_1)));
            if (CollectionsKt.none((Iterable)chords)) {
                text.element = "";
                this.parseMarkers(line, Song.CHORD_START, Song.CHORD_END, (Function2<? super String, ? super Boolean, Unit>)((Function2)(arg_0, arg_1) -> Companion.extractChords$lambda$6(chords, text, isTab, arg_0, arg_1)));
            }
            return TuplesKt.to((Object)text.element, (Object)chords);
        }

        private final void parseMarkers(String content, String startMarker, String endMarker, Function2<? super String, ? super Boolean, Unit> fn) {
            String workingContent = null;
            workingContent = content;
            int startMarkerLength = startMarker.length();
            int endMarkerLength = endMarker.length();
            while (((CharSequence)workingContent).length() > 0) {
                String it;
                int n;
                int startIndex = StringsKt.indexOf$default((CharSequence)workingContent, (String)startMarker, (int)0, (boolean)false, (int)6, null);
                if (startIndex == 0) {
                    int it2 = StringsKt.indexOf$default((CharSequence)workingContent, (String)endMarker, (int)startIndex, (boolean)false, (int)4, null);
                    boolean bl = false;
                    n = it2 == -1 ? workingContent.length() : it2 + endMarkerLength;
                } else {
                    n = startIndex > 0 ? startIndex : workingContent.length();
                }
                int endIndex = n;
                Intrinsics.checkNotNullExpressionValue((Object)workingContent.substring(0, endIndex), (String)"substring(...)");
                boolean bl = false;
                int start = StringsKt.startsWith$default((String)it, (String)startMarker, (boolean)false, (int)2, null) ? startMarkerLength : 0;
                int end = it.length() - (StringsKt.endsWith$default((String)it, (String)endMarker, (boolean)false, (int)2, null) ? endMarkerLength : 0);
                String string = it.substring(start, end);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                char[] cArray = new char[]{'\r', '\n'};
                String markerContent = StringsKt.trim((String)string, (char[])cArray);
                if (((CharSequence)markerContent).length() > 0) {
                    fn.invoke((Object)markerContent, (Object)(startIndex == 0 ? 1 : 0));
                }
                Intrinsics.checkNotNullExpressionValue((Object)workingContent.substring(endIndex), (String)"substring(...)");
            }
        }

        private static final Unit parseLines$lambda$2$lambda$1(List $this_apply, String text, boolean isTab) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            List<String> textLines = Companion.getLines(text);
            $this_apply.addAll((Collection)Companion.parseLines(textLines, CollectionsKt.emptyList(), isTab));
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit extractChords$lambda$4(List $chords, Ref.ObjectRef $text, boolean $isTab, String chordText, boolean isChord) {
            Intrinsics.checkNotNullParameter((Object)chordText, (String)"chordText");
            if (isChord) {
                int n;
                List list = $chords;
                String string = chordText;
                int n2 = ((String)$text.element).length();
                if ($isTab) {
                    int n3;
                    Iterable iterable = $chords;
                    int n4 = n2;
                    String string2 = string;
                    List list2 = list;
                    int n5 = 0;
                    for (Object t : iterable) {
                        void it;
                        Chord chord = (Chord)t;
                        n3 = n5;
                        boolean bl = false;
                        int n6 = it.getName().length();
                        n5 = n3 + n6;
                    }
                    n3 = n5;
                    list = list2;
                    string = string2;
                    n2 = n4;
                    n = n3;
                } else {
                    n = 0;
                }
                DefaultConstructorMarker defaultConstructorMarker = null;
                int n7 = 4;
                boolean bl = false;
                int n8 = n2 + n;
                String string3 = string;
                list.add(new Chord(string3, n8, bl, n7, defaultConstructorMarker));
            } else {
                $text.element = (String)$text.element + chordText;
            }
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit extractChords$lambda$6(List $chords, Ref.ObjectRef $text, boolean $isTab, String chordText, boolean isChord) {
            Intrinsics.checkNotNullParameter((Object)chordText, (String)"chordText");
            if (isChord) {
                int n;
                List list = $chords;
                String string = chordText;
                int n2 = ((String)$text.element).length();
                if ($isTab) {
                    int n3;
                    Iterable iterable = $chords;
                    int n4 = n2;
                    String string2 = string;
                    List list2 = list;
                    int n5 = 0;
                    for (Object t : iterable) {
                        void it;
                        Chord chord = (Chord)t;
                        n3 = n5;
                        boolean bl = false;
                        int n6 = it.getName().length();
                        n5 = n3 + n6;
                    }
                    n3 = n5;
                    list = list2;
                    string = string2;
                    n2 = n4;
                    n = n3;
                } else {
                    n = 0;
                }
                boolean bl = true;
                int n7 = n2 + n;
                String string3 = string;
                list.add(new Chord(string3, n7, bl));
            } else {
                $text.element = (String)$text.element + chordText;
            }
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

