/*
 * Copyright © 2018-2020 Peter M. Stahl pemistahl@gmail.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either expressed or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.github.pemistahl.lingua.api

/**
 * The ISO 639-1 code representations for the supported languages.
 *
 * ISO 639 is a standardized nomenclature used to classify languages.
 */
enum class IsoCode639_1 {

    /**
     * The ISO 639-1 code for [Afrikaans][Language.AFRIKAANS].
     */
    AF,

    /**
     * The ISO 639-1 code for [Arabic][Language.ARABIC].
     */
    AR,

    /**
     * The ISO 639-1 code for [Azerbaijani][Language.AZERBAIJANI].
     */
    AZ,

    /**
     * The ISO 639-1 code for [Belarusian][Language.BELARUSIAN].
     */
    BE,

    /**
     * The ISO 639-1 code for [Bulgarian][Language.BULGARIAN].
     */
    BG,

    /**
     * The ISO 639-1 code for [Bengali][Language.BENGALI].
     */
    BN,

    /**
     * The ISO 639-1 code for [Bosnian][Language.BOSNIAN].
     */
    BS,

    /**
     * The ISO 639-1 code for [Catalan][Language.CATALAN].
     */
    CA,

    /**
     * The ISO 639-1 code for [Czech][Language.CZECH].
     */
    CS,

    /**
     * The ISO 639-1 code for [Welsh][Language.WELSH].
     */
    CY,

    /**
     * The ISO 639-1 code for [Danish][Language.DANISH].
     */
    DA,

    /**
     * The ISO 639-1 code for [German][Language.GERMAN].
     */
    DE,

    /**
     * The ISO 639-1 code for [Greek][Language.GREEK].
     */
    EL,

    /**
     * The ISO 639-1 code for [English][Language.ENGLISH].
     */
    EN,

    /**
     * The ISO 639-1 code for [Esperanto][Language.ESPERANTO].
     */
    EO,

    /**
     * The ISO 639-1 code for [Spanish][Language.SPANISH].
     */
    ES,

    /**
     * The ISO 639-1 code for [Estonian][Language.ESTONIAN].
     */
    ET,

    /**
     * The ISO 639-1 code for [Basque][Language.BASQUE].
     */
    EU,

    /**
     * The ISO 639-1 code for [Persian][Language.PERSIAN].
     */
    FA,

    /**
     * The ISO 639-1 code for [Finnish][Language.FINNISH].
     */
    FI,

    /**
     * The ISO 639-1 code for [French][Language.FRENCH].
     */
    FR,

    /**
     * The ISO 639-1 code for [Irish][Language.IRISH].
     */
    GA,

    /**
     * The ISO 639-1 code for [Gujarati][Language.GUJARATI].
     */
    GU,

    /**
     * The ISO 639-1 code for [Hebrew][Language.HEBREW].
     */
    HE,

    /**
     * The ISO 639-1 code for [Hindi][Language.HINDI].
     */
    HI,

    /**
     * The ISO 639-1 code for [Croatian][Language.CROATIAN].
     */
    HR,

    /**
     * The ISO 639-1 code for [Hungarian][Language.HUNGARIAN].
     */
    HU,

    /**
     * The ISO 639-1 code for [Armenian][Language.ARMENIAN].
     */
    HY,

    /**
     * The ISO 639-1 code for [Indonesian][Language.INDONESIAN].
     */
    ID,

    /**
     * The ISO 639-1 code for [Icelandic][Language.ICELANDIC].
     */
    IS,

    /**
     * The ISO 639-1 code for [Italian][Language.ITALIAN].
     */
    IT,

    /**
     * The ISO 639-1 code for [Japanese][Language.JAPANESE].
     */
    JA,

    /**
     * The ISO 639-1 code for [Georgian][Language.GEORGIAN].
     */
    KA,

    /**
     * The ISO 639-1 code for [Kazakh][Language.KAZAKH].
     */
    KK,

    /**
     * The ISO 639-1 code for [Korean][Language.KOREAN].
     */
    KO,

    /**
     * The ISO 639-1 code for [Latin][Language.LATIN].
     */
    LA,

    /**
     * The ISO 639-1 code for [Ganda][Language.GANDA].
     */
    LG,

    /**
     * The ISO 639-1 code for [Lithuanian][Language.LITHUANIAN].
     */
    LT,

    /**
     * The ISO 639-1 code for [Latvian][Language.LATVIAN].
     */
    LV,

    /**
     * The ISO 639-1 code for [Macedonian][Language.MACEDONIAN].
     */
    MK,

    /**
     * The ISO 639-1 code for [Mongolian][Language.MONGOLIAN].
     */
    MN,

    /**
     * The ISO 639-1 code for [Marathi][Language.MARATHI].
     */
    MR,

    /**
     * The ISO 639-1 code for [Malay][Language.MALAY].
     */
    MS,

    /**
     * The ISO 639-1 code for [Norwegian Bokmal][Language.BOKMAL].
     */
    NB,

    /**
     * The ISO 639-1 code for [Dutch][Language.DUTCH].
     */
    NL,

    /**
     * The ISO 639-1 code for [Norwegian Nynorsk][Language.NYNORSK].
     */
    NN,

    /**
     * The ISO 639-1 code for [Punjabi][Language.PUNJABI].
     */
    PA,

    /**
     * The ISO 639-1 code for [Polish][Language.POLISH].
     */
    PL,

    /**
     * The ISO 639-1 code for [Portuguese][Language.PORTUGUESE].
     */
    PT,

    /**
     * The ISO 639-1 code for [Romanian][Language.ROMANIAN].
     */
    RO,

    /**
     * The ISO 639-1 code for [Russian][Language.RUSSIAN].
     */
    RU,

    /**
     * The ISO 639-1 code for [Slovak][Language.SLOVAK].
     */
    SK,

    /**
     * The ISO 639-1 code for [Slovene][Language.SLOVENE].
     */
    SL,

    /**
     * The ISO 639-1 code for [Shona][Language.SHONA].
     */
    SN,

    /**
     * The ISO 639-1 code for [Somali][Language.SOMALI].
     */
    SO,

    /**
     * The ISO 639-1 code for [Albanian][Language.ALBANIAN].
     */
    SQ,

    /**
     * The ISO 639-1 code for [Serbian][Language.SERBIAN].
     */
    SR,

    /**
     * The ISO 639-1 code for [Southern Sotho][Language.SOTHO].
     */
    ST,

    /**
     * The ISO 639-1 code for [Swedish][Language.SWEDISH].
     */
    SV,

    /**
     * The ISO 639-1 code for [Swahili][Language.SWAHILI].
     */
    SW,

    /**
     * The ISO 639-1 code for [Tamil][Language.TAMIL].
     */
    TA,

    /**
     * The ISO 639-1 code for [Telugu][Language.TELUGU].
     */
    TE,

    /**
     * The ISO 639-1 code for [Thai][Language.THAI].
     */
    TH,

    /**
     * The ISO 639-1 code for [Tagalog][Language.TAGALOG].
     */
    TL,

    /**
     * The ISO 639-1 code for [Tswana][Language.TSWANA].
     */
    TN,

    /**
     * The ISO 639-1 code for [Turkish][Language.TURKISH].
     */
    TR,

    /**
     * The ISO 639-1 code for [Tsonga][Language.TSONGA].
     */
    TS,

    /**
     * The ISO 639-1 code for [Ukrainian][Language.UKRAINIAN].
     */
    UK,

    /**
     * The ISO 639-1 code for [Urdu][Language.URDU].
     */
    UR,

    /**
     * The ISO 639-1 code for [Vietnamese][Language.VIETNAMESE].
     */
    VI,

    /**
     * The ISO 639-1 code for [Xhosa][Language.XHOSA].
     */
    XH,

    /**
     * The ISO 639-1 code for [Yoruba][Language.YORUBA].
     */
    YO,

    /**
     * The ISO 639-1 code for [Chinese][Language.CHINESE].
     */
    ZH,

    /**
     * The ISO 639-1 code for [Zulu][Language.ZULU].
     */
    ZU,

    /**
     * The ISO 639-1 code for [the imaginary unknown language][Language.UNKNOWN].
     */
    NONE;

    override fun toString() = this.name.toLowerCase()
}
